/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Component;
import com.banuba.sdk.scene.ComponentType;
import com.banuba.sdk.scene.Layer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Entity {
    public void setName(@NonNull String var1);

    @NonNull
    public String getName();

    public void addChild(@Nullable Entity var1);

    public void removeChild(@Nullable Entity var1);

    @NonNull
    public ArrayList<Entity> getChildren();

    public void clearChildren();

    @Nullable
    public Entity findChildByName(@NonNull String var1);

    @Nullable
    public Entity getParent();

    public void setActive(boolean var1);

    public boolean isActive();

    public void addIntoLayer(@Nullable Layer var1);

    public void removeFromLayer(@Nullable Layer var1);

    @NonNull
    public ArrayList<Layer> getLayers();

    public void addComponent(@Nullable Component var1);

    public boolean hasComponent(@NonNull ComponentType var1);

    @Nullable
    public Component getComponent(@NonNull ComponentType var1);

    public void removeComponent(@Nullable Component var1);

    @Keep
    public static final class CppProxy
    implements Entity {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setName(long var1, String var3);

        private native String native_getName(long var1);

        private native void native_addChild(long var1, Entity var3);

        private native void native_removeChild(long var1, Entity var3);

        private native ArrayList<Entity> native_getChildren(long var1);

        private native void native_clearChildren(long var1);

        private native Entity native_findChildByName(long var1, String var3);

        private native Entity native_getParent(long var1);

        private native void native_setActive(long var1, boolean var3);

        private native boolean native_isActive(long var1);

        private native void native_addIntoLayer(long var1, Layer var3);

        private native void native_removeFromLayer(long var1, Layer var3);

        private native ArrayList<Layer> native_getLayers(long var1);

        private native void native_addComponent(long var1, Component var3);

        private native boolean native_hasComponent(long var1, ComponentType var3);

        private native Component native_getComponent(long var1, ComponentType var3);

        private native void native_removeComponent(long var1, Component var3);

        static {
            $assertionsDisabled = Entity.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setName(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setName(cppProxy.nativeRef, string);
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void addChild(Entity entity) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addChild(cppProxy.nativeRef, entity);
        }

        @Override
        public void removeChild(Entity entity) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeChild(cppProxy.nativeRef, entity);
        }

        @Override
        public ArrayList<Entity> getChildren() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getChildren(cppProxy.nativeRef);
        }

        @Override
        public void clearChildren() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_clearChildren(cppProxy.nativeRef);
        }

        @Override
        public Entity findChildByName(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findChildByName(cppProxy.nativeRef, string);
        }

        @Override
        public Entity getParent() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getParent(cppProxy.nativeRef);
        }

        @Override
        public void setActive(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setActive(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean isActive() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isActive(cppProxy.nativeRef);
        }

        @Override
        public void addIntoLayer(Layer layer) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addIntoLayer(cppProxy.nativeRef, layer);
        }

        @Override
        public void removeFromLayer(Layer layer) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeFromLayer(cppProxy.nativeRef, layer);
        }

        @Override
        public ArrayList<Layer> getLayers() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLayers(cppProxy.nativeRef);
        }

        @Override
        public void addComponent(Component component) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addComponent(cppProxy.nativeRef, component);
        }

        @Override
        public boolean hasComponent(ComponentType componentType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_hasComponent(cppProxy.nativeRef, componentType);
        }

        @Override
        public Component getComponent(ComponentType componentType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getComponent(cppProxy.nativeRef, componentType);
        }

        @Override
        public void removeComponent(Component component) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeComponent(cppProxy.nativeRef, component);
        }
    }
}

