/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Component;
import com.banuba.sdk.scene.Ear;
import com.banuba.sdk.scene.EyesStatus;
import com.banuba.sdk.scene.Face;
import com.banuba.sdk.types.Gender;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface FaceTracker {
    @Nullable
    public static FaceTracker create() {
        return CppProxy.create();
    }

    public void setFace(@Nullable Face var1);

    @Nullable
    public Face getFace();

    public boolean hasFace();

    public boolean isMouthOpen();

    public boolean isSmiling();

    public boolean isEyebrowsUp();

    public boolean isDisgust();

    @NonNull
    public EyesStatus getEyesStatus();

    @NonNull
    public ArrayList<Ear> getEars();

    @Nullable
    public Component asComponent();

    @NonNull
    public Gender getGender();

    @Keep
    public static final class CppProxy
    implements FaceTracker {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setFace(long var1, Face var3);

        private native Face native_getFace(long var1);

        private native boolean native_hasFace(long var1);

        private native boolean native_isMouthOpen(long var1);

        private native boolean native_isSmiling(long var1);

        private native boolean native_isEyebrowsUp(long var1);

        private native boolean native_isDisgust(long var1);

        private native EyesStatus native_getEyesStatus(long var1);

        private native ArrayList<Ear> native_getEars(long var1);

        private native Component native_asComponent(long var1);

        private native Gender native_getGender(long var1);

        @Nullable
        public static native FaceTracker create();

        static {
            $assertionsDisabled = FaceTracker.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setFace(Face face) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFace(cppProxy.nativeRef, face);
        }

        @Override
        public Face getFace() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFace(cppProxy.nativeRef);
        }

        @Override
        public boolean hasFace() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_hasFace(cppProxy.nativeRef);
        }

        @Override
        public boolean isMouthOpen() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isMouthOpen(cppProxy.nativeRef);
        }

        @Override
        public boolean isSmiling() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isSmiling(cppProxy.nativeRef);
        }

        @Override
        public boolean isEyebrowsUp() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isEyebrowsUp(cppProxy.nativeRef);
        }

        @Override
        public boolean isDisgust() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isDisgust(cppProxy.nativeRef);
        }

        @Override
        public EyesStatus getEyesStatus() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getEyesStatus(cppProxy.nativeRef);
        }

        @Override
        public ArrayList<Ear> getEars() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getEars(cppProxy.nativeRef);
        }

        @Override
        public Component asComponent() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asComponent(cppProxy.nativeRef);
        }

        @Override
        public Gender getGender() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getGender(cppProxy.nativeRef);
        }
    }
}

