/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.GestureType;
import com.banuba.sdk.scene.Mesh;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Hand {
    @NonNull
    public String getName();

    public void setMesh(@Nullable Mesh var1);

    @Nullable
    public Mesh getMesh();

    @NonNull
    public GestureType getGesture();

    @Keep
    public static final class CppProxy
    implements Hand {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_getName(long var1);

        private native void native_setMesh(long var1, Mesh var3);

        private native Mesh native_getMesh(long var1);

        private native GestureType native_getGesture(long var1);

        static {
            $assertionsDisabled = Hand.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void setMesh(Mesh mesh) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMesh(cppProxy.nativeRef, mesh);
        }

        @Override
        public Mesh getMesh() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMesh(cppProxy.nativeRef);
        }

        @Override
        public GestureType getGesture() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getGesture(cppProxy.nativeRef);
        }
    }
}

