/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Component;
import com.banuba.sdk.scene.Hand;
import com.banuba.sdk.scene.HandTrackerType;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface HandTracker {
    @Nullable
    public static HandTracker create() {
        return CppProxy.create();
    }

    public void setHand(@Nullable Hand var1);

    @Nullable
    public Hand getHand();

    @NonNull
    public HandTrackerType getType();

    public void setType(@NonNull HandTrackerType var1);

    @Nullable
    public Component asComponent();

    @Keep
    public static final class CppProxy
    implements HandTracker {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setHand(long var1, Hand var3);

        private native Hand native_getHand(long var1);

        private native HandTrackerType native_getType(long var1);

        private native void native_setType(long var1, HandTrackerType var3);

        private native Component native_asComponent(long var1);

        @Nullable
        public static native HandTracker create();

        static {
            $assertionsDisabled = HandTracker.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setHand(Hand hand) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setHand(cppProxy.nativeRef, hand);
        }

        @Override
        public Hand getHand() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHand(cppProxy.nativeRef);
        }

        @Override
        public HandTrackerType getType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getType(cppProxy.nativeRef);
        }

        @Override
        public void setType(HandTrackerType handTrackerType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setType(cppProxy.nativeRef, handTrackerType);
        }

        @Override
        public Component asComponent() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asComponent(cppProxy.nativeRef);
        }
    }
}

