/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Attachment;
import com.banuba.sdk.scene.CameraTexture;
import com.banuba.sdk.scene.Cubemap;
import com.banuba.sdk.scene.ImageType;
import com.banuba.sdk.scene.ProceduralTexture;
import com.banuba.sdk.scene.SegmentationMask;
import com.banuba.sdk.scene.TextTexture;
import com.banuba.sdk.scene.Texture;
import com.banuba.sdk.scene.Video;
import com.banuba.sdk.scene.WeightedLut;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Image {
    @NonNull
    public String getName();

    @NonNull
    public ImageType getType();

    @Nullable
    public Attachment asAttachment();

    @Nullable
    public Cubemap asCubemap();

    @Nullable
    public SegmentationMask asSegmentationMask();

    @Nullable
    public Texture asTexture();

    @Nullable
    public CameraTexture asCameraTexture();

    @Nullable
    public Video asVideo();

    @Nullable
    public WeightedLut asWeightedLut();

    @Nullable
    public TextTexture asTextTexture();

    @Nullable
    public ProceduralTexture asProceduralTexture();

    @Keep
    public static final class CppProxy
    implements Image {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_getName(long var1);

        private native ImageType native_getType(long var1);

        private native Attachment native_asAttachment(long var1);

        private native Cubemap native_asCubemap(long var1);

        private native SegmentationMask native_asSegmentationMask(long var1);

        private native Texture native_asTexture(long var1);

        private native CameraTexture native_asCameraTexture(long var1);

        private native Video native_asVideo(long var1);

        private native WeightedLut native_asWeightedLut(long var1);

        private native TextTexture native_asTextTexture(long var1);

        private native ProceduralTexture native_asProceduralTexture(long var1);

        static {
            $assertionsDisabled = Image.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public ImageType getType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getType(cppProxy.nativeRef);
        }

        @Override
        public Attachment asAttachment() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asAttachment(cppProxy.nativeRef);
        }

        @Override
        public Cubemap asCubemap() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asCubemap(cppProxy.nativeRef);
        }

        @Override
        public SegmentationMask asSegmentationMask() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asSegmentationMask(cppProxy.nativeRef);
        }

        @Override
        public Texture asTexture() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asTexture(cppProxy.nativeRef);
        }

        @Override
        public CameraTexture asCameraTexture() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asCameraTexture(cppProxy.nativeRef);
        }

        @Override
        public Video asVideo() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asVideo(cppProxy.nativeRef);
        }

        @Override
        public WeightedLut asWeightedLut() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asWeightedLut(cppProxy.nativeRef);
        }

        @Override
        public TextTexture asTextTexture() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asTextTexture(cppProxy.nativeRef);
        }

        @Override
        public ProceduralTexture asProceduralTexture() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asProceduralTexture(cppProxy.nativeRef);
        }
    }
}

