/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Layer {
    @Nullable
    public static Layer create(@NonNull String string) {
        return CppProxy.create(string);
    }

    public void setName(@NonNull String var1);

    @NonNull
    public String getName();

    public void setActive(boolean var1);

    public boolean isActive();

    public void enableMorphing(boolean var1);

    public boolean isMorphingEnabled();

    @Keep
    public static final class CppProxy
    implements Layer {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setName(long var1, String var3);

        private native String native_getName(long var1);

        private native void native_setActive(long var1, boolean var3);

        private native boolean native_isActive(long var1);

        private native void native_enableMorphing(long var1, boolean var3);

        private native boolean native_isMorphingEnabled(long var1);

        @Nullable
        public static native Layer create(@NonNull String var0);

        static {
            $assertionsDisabled = Layer.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setName(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setName(cppProxy.nativeRef, string);
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void setActive(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setActive(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean isActive() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isActive(cppProxy.nativeRef);
        }

        @Override
        public void enableMorphing(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_enableMorphing(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean isMorphingEnabled() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isMorphingEnabled(cppProxy.nativeRef);
        }
    }
}

