/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.GeometryTopology;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.Parameter;
import com.banuba.sdk.scene.ShaderSource;
import com.banuba.sdk.scene.State;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Material {
    @NonNull
    public String getName();

    public void addParameter(@Nullable Parameter var1);

    @NonNull
    public ArrayList<Parameter> getParameters();

    public void removeParameter(@Nullable Parameter var1);

    @Nullable
    public Parameter findParameter(@NonNull String var1);

    public void setTopology(@NonNull GeometryTopology var1);

    @NonNull
    public GeometryTopology getCurrentTopology();

    public void setState(@NonNull State var1);

    @NonNull
    public State getState();

    public void addImage(@NonNull String var1, @Nullable Image var2);

    @NonNull
    public ArrayList<Image> getImages();

    public void removeImage(@NonNull String var1);

    @NonNull
    public ArrayList<String> getSamplers();

    @NonNull
    public ShaderSource getShaderSource();

    @Keep
    public static final class CppProxy
    implements Material {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_getName(long var1);

        private native void native_addParameter(long var1, Parameter var3);

        private native ArrayList<Parameter> native_getParameters(long var1);

        private native void native_removeParameter(long var1, Parameter var3);

        private native Parameter native_findParameter(long var1, String var3);

        private native void native_setTopology(long var1, GeometryTopology var3);

        private native GeometryTopology native_getCurrentTopology(long var1);

        private native void native_setState(long var1, State var3);

        private native State native_getState(long var1);

        private native void native_addImage(long var1, String var3, Image var4);

        private native ArrayList<Image> native_getImages(long var1);

        private native void native_removeImage(long var1, String var3);

        private native ArrayList<String> native_getSamplers(long var1);

        private native ShaderSource native_getShaderSource(long var1);

        static {
            $assertionsDisabled = Material.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void addParameter(Parameter parameter) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addParameter(cppProxy.nativeRef, parameter);
        }

        @Override
        public ArrayList<Parameter> getParameters() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getParameters(cppProxy.nativeRef);
        }

        @Override
        public void removeParameter(Parameter parameter) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeParameter(cppProxy.nativeRef, parameter);
        }

        @Override
        public Parameter findParameter(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findParameter(cppProxy.nativeRef, string);
        }

        @Override
        public void setTopology(GeometryTopology geometryTopology) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setTopology(cppProxy.nativeRef, geometryTopology);
        }

        @Override
        public GeometryTopology getCurrentTopology() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getCurrentTopology(cppProxy.nativeRef);
        }

        @Override
        public void setState(State state) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setState(cppProxy.nativeRef, state);
        }

        @Override
        public State getState() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getState(cppProxy.nativeRef);
        }

        @Override
        public void addImage(String string, Image image) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addImage(cppProxy.nativeRef, string, image);
        }

        @Override
        public ArrayList<Image> getImages() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getImages(cppProxy.nativeRef);
        }

        @Override
        public void removeImage(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeImage(cppProxy.nativeRef, string);
        }

        @Override
        public ArrayList<String> getSamplers() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSamplers(cppProxy.nativeRef);
        }

        @Override
        public ShaderSource getShaderSource() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getShaderSource(cppProxy.nativeRef);
        }
    }
}

