/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Media {
    public void setStartPosition(float var1);

    public void setEndPosition(float var1);

    public void setLooped(boolean var1);

    public boolean isLooped();

    public float getStartPosition();

    public float getEndPosition();

    public boolean isPlaying();

    public void play();

    public void pause();

    public void stop();

    public void resume();

    @Keep
    public static final class CppProxy
    implements Media {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setStartPosition(long var1, float var3);

        private native void native_setEndPosition(long var1, float var3);

        private native void native_setLooped(long var1, boolean var3);

        private native boolean native_isLooped(long var1);

        private native float native_getStartPosition(long var1);

        private native float native_getEndPosition(long var1);

        private native boolean native_isPlaying(long var1);

        private native void native_play(long var1);

        private native void native_pause(long var1);

        private native void native_stop(long var1);

        private native void native_resume(long var1);

        static {
            $assertionsDisabled = Media.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setStartPosition(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setStartPosition(cppProxy.nativeRef, f);
        }

        @Override
        public void setEndPosition(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setEndPosition(cppProxy.nativeRef, f);
        }

        @Override
        public void setLooped(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setLooped(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean isLooped() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isLooped(cppProxy.nativeRef);
        }

        @Override
        public float getStartPosition() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getStartPosition(cppProxy.nativeRef);
        }

        @Override
        public float getEndPosition() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getEndPosition(cppProxy.nativeRef);
        }

        @Override
        public boolean isPlaying() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isPlaying(cppProxy.nativeRef);
        }

        @Override
        public void play() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_play(cppProxy.nativeRef);
        }

        @Override
        public void pause() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_pause(cppProxy.nativeRef);
        }

        @Override
        public void stop() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_stop(cppProxy.nativeRef);
        }

        @Override
        public void resume() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_resume(cppProxy.nativeRef);
        }
    }
}

