/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.AnimationMode;
import com.banuba.sdk.scene.Component;
import com.banuba.sdk.scene.Material;
import com.banuba.sdk.scene.Mesh;
import com.banuba.sdk.scene.PhysicsSimulator;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface MeshInstance {
    @Nullable
    public static MeshInstance create() {
        return CppProxy.create();
    }

    public void setVisible(boolean var1);

    public boolean isVisible();

    public void setSubGeometryMaterial(@NonNull String var1, @Nullable Material var2);

    @Nullable
    public Material getSubGeometryMaterial(@NonNull String var1);

    @NonNull
    public ArrayList<Material> getMaterials();

    public void setMesh(@Nullable Mesh var1);

    @Nullable
    public Mesh getMesh();

    public void animationChange(@NonNull String var1, @NonNull AnimationMode var2);

    public void animationPlay();

    public void animationPause();

    public void animationSeek(long var1);

    public boolean isAnimationPlaying();

    public boolean isAnimationEnded();

    @NonNull
    public String getAnimation();

    @NonNull
    public AnimationMode getAnimationMode();

    public long getAnimationPositionNs();

    public long getAnimationDurationNs();

    public long getAnimationTimeOffsetNs();

    public void setAnimationTimeOffsetNs(long var1);

    @Nullable
    public PhysicsSimulator getPhysicsSimulator();

    @Nullable
    public Component asComponent();

    @Keep
    public static final class CppProxy
    implements MeshInstance {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setVisible(long var1, boolean var3);

        private native boolean native_isVisible(long var1);

        private native void native_setSubGeometryMaterial(long var1, String var3, Material var4);

        private native Material native_getSubGeometryMaterial(long var1, String var3);

        private native ArrayList<Material> native_getMaterials(long var1);

        private native void native_setMesh(long var1, Mesh var3);

        private native Mesh native_getMesh(long var1);

        private native void native_animationChange(long var1, String var3, AnimationMode var4);

        private native void native_animationPlay(long var1);

        private native void native_animationPause(long var1);

        private native void native_animationSeek(long var1, long var3);

        private native boolean native_isAnimationPlaying(long var1);

        private native boolean native_isAnimationEnded(long var1);

        private native String native_getAnimation(long var1);

        private native AnimationMode native_getAnimationMode(long var1);

        private native long native_getAnimationPositionNs(long var1);

        private native long native_getAnimationDurationNs(long var1);

        private native long native_getAnimationTimeOffsetNs(long var1);

        private native void native_setAnimationTimeOffsetNs(long var1, long var3);

        private native PhysicsSimulator native_getPhysicsSimulator(long var1);

        private native Component native_asComponent(long var1);

        @Nullable
        public static native MeshInstance create();

        static {
            $assertionsDisabled = MeshInstance.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setVisible(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setVisible(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean isVisible() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isVisible(cppProxy.nativeRef);
        }

        @Override
        public void setSubGeometryMaterial(String string, Material material) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setSubGeometryMaterial(cppProxy.nativeRef, string, material);
        }

        @Override
        public Material getSubGeometryMaterial(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSubGeometryMaterial(cppProxy.nativeRef, string);
        }

        @Override
        public ArrayList<Material> getMaterials() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMaterials(cppProxy.nativeRef);
        }

        @Override
        public void setMesh(Mesh mesh) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMesh(cppProxy.nativeRef, mesh);
        }

        @Override
        public Mesh getMesh() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMesh(cppProxy.nativeRef);
        }

        @Override
        public void animationChange(String string, AnimationMode animationMode) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_animationChange(cppProxy.nativeRef, string, animationMode);
        }

        @Override
        public void animationPlay() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_animationPlay(cppProxy.nativeRef);
        }

        @Override
        public void animationPause() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_animationPause(cppProxy.nativeRef);
        }

        @Override
        public void animationSeek(long l) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_animationSeek(cppProxy.nativeRef, l);
        }

        @Override
        public boolean isAnimationPlaying() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isAnimationPlaying(cppProxy.nativeRef);
        }

        @Override
        public boolean isAnimationEnded() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isAnimationEnded(cppProxy.nativeRef);
        }

        @Override
        public String getAnimation() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAnimation(cppProxy.nativeRef);
        }

        @Override
        public AnimationMode getAnimationMode() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAnimationMode(cppProxy.nativeRef);
        }

        @Override
        public long getAnimationPositionNs() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAnimationPositionNs(cppProxy.nativeRef);
        }

        @Override
        public long getAnimationDurationNs() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAnimationDurationNs(cppProxy.nativeRef);
        }

        @Override
        public long getAnimationTimeOffsetNs() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAnimationTimeOffsetNs(cppProxy.nativeRef);
        }

        @Override
        public void setAnimationTimeOffsetNs(long l) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setAnimationTimeOffsetNs(cppProxy.nativeRef, l);
        }

        @Override
        public PhysicsSimulator getPhysicsSimulator() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getPhysicsSimulator(cppProxy.nativeRef);
        }

        @Override
        public Component asComponent() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asComponent(cppProxy.nativeRef);
        }
    }
}

