/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Mesh;
import com.banuba.sdk.scene.MorphingType;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Morphing {
    @NonNull
    public MorphingType getType();

    @NonNull
    public String getName();

    public void setWarpMesh(@Nullable Mesh var1);

    @Nullable
    public Mesh getWarpMesh();

    @Keep
    public static final class CppProxy
    implements Morphing {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native MorphingType native_getType(long var1);

        private native String native_getName(long var1);

        private native void native_setWarpMesh(long var1, Mesh var3);

        private native Mesh native_getWarpMesh(long var1);

        static {
            $assertionsDisabled = Morphing.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public MorphingType getType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getType(cppProxy.nativeRef);
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void setWarpMesh(Mesh mesh) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setWarpMesh(cppProxy.nativeRef, mesh);
        }

        @Override
        public Mesh getWarpMesh() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getWarpMesh(cppProxy.nativeRef);
        }
    }
}

