/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Mat2x4;
import com.banuba.sdk.scene.Mat3x4;
import com.banuba.sdk.scene.Mat4x4;
import com.banuba.sdk.scene.Vec3;
import com.banuba.sdk.scene.Vec4;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Parameter {
    @Nullable
    public static Parameter create(@NonNull String string) {
        return CppProxy.create(string);
    }

    @NonNull
    public String getName();

    public void setInteger(int var1);

    public int getInteger();

    public void setReal(float var1);

    public float getReal();

    public void setX(float var1);

    public void setY(float var1);

    public void setZ(float var1);

    public void setW(float var1);

    public void setVector3(@NonNull Vec3 var1);

    @NonNull
    public Vec3 getVector3();

    public void setVector4(@NonNull Vec4 var1);

    @NonNull
    public Vec4 getVector4();

    public void setMat2x4(@NonNull Mat2x4 var1);

    @NonNull
    public Mat2x4 getMat2x4();

    public void setMat3x4(@NonNull Mat3x4 var1);

    @NonNull
    public Mat3x4 getMat3x4();

    public void setMat4x4(@NonNull Mat4x4 var1);

    @NonNull
    public Mat4x4 getMat4x4();

    @Keep
    public static final class CppProxy
    implements Parameter {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_getName(long var1);

        private native void native_setInteger(long var1, int var3);

        private native int native_getInteger(long var1);

        private native void native_setReal(long var1, float var3);

        private native float native_getReal(long var1);

        private native void native_setX(long var1, float var3);

        private native void native_setY(long var1, float var3);

        private native void native_setZ(long var1, float var3);

        private native void native_setW(long var1, float var3);

        private native void native_setVector3(long var1, Vec3 var3);

        private native Vec3 native_getVector3(long var1);

        private native void native_setVector4(long var1, Vec4 var3);

        private native Vec4 native_getVector4(long var1);

        private native void native_setMat2x4(long var1, Mat2x4 var3);

        private native Mat2x4 native_getMat2x4(long var1);

        private native void native_setMat3x4(long var1, Mat3x4 var3);

        private native Mat3x4 native_getMat3x4(long var1);

        private native void native_setMat4x4(long var1, Mat4x4 var3);

        private native Mat4x4 native_getMat4x4(long var1);

        @Nullable
        public static native Parameter create(@NonNull String var0);

        static {
            $assertionsDisabled = Parameter.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void setInteger(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setInteger(cppProxy.nativeRef, n);
        }

        @Override
        public int getInteger() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getInteger(cppProxy.nativeRef);
        }

        @Override
        public void setReal(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setReal(cppProxy.nativeRef, f);
        }

        @Override
        public float getReal() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getReal(cppProxy.nativeRef);
        }

        @Override
        public void setX(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setX(cppProxy.nativeRef, f);
        }

        @Override
        public void setY(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setY(cppProxy.nativeRef, f);
        }

        @Override
        public void setZ(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setZ(cppProxy.nativeRef, f);
        }

        @Override
        public void setW(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setW(cppProxy.nativeRef, f);
        }

        @Override
        public void setVector3(Vec3 vec3) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setVector3(cppProxy.nativeRef, vec3);
        }

        @Override
        public Vec3 getVector3() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getVector3(cppProxy.nativeRef);
        }

        @Override
        public void setVector4(Vec4 vec4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setVector4(cppProxy.nativeRef, vec4);
        }

        @Override
        public Vec4 getVector4() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getVector4(cppProxy.nativeRef);
        }

        @Override
        public void setMat2x4(Mat2x4 mat2x4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMat2x4(cppProxy.nativeRef, mat2x4);
        }

        @Override
        public Mat2x4 getMat2x4() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMat2x4(cppProxy.nativeRef);
        }

        @Override
        public void setMat3x4(Mat3x4 mat3x4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMat3x4(cppProxy.nativeRef, mat3x4);
        }

        @Override
        public Mat3x4 getMat3x4() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMat3x4(cppProxy.nativeRef);
        }

        @Override
        public void setMat4x4(Mat4x4 mat4x4) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMat4x4(cppProxy.nativeRef, mat4x4);
        }

        @Override
        public Mat4x4 getMat4x4() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMat4x4(cppProxy.nativeRef);
        }
    }
}

