/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.banuba.sdk.scene.Vec3;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface PhysicsSimulator {
    public void setGravity(@NonNull Vec3 var1);

    public void setDamping(float var1);

    public void setInvMass(@NonNull String var1, float var2);

    public void setSphereCollider(int var1, @NonNull Vec3 var2, float var3);

    public void setConstraint(@NonNull String var1, @NonNull String var2, float var3);

    public void setBonesInMvSpace(boolean var1);

    public void reset();

    @Keep
    public static final class CppProxy
    implements PhysicsSimulator {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setGravity(long var1, Vec3 var3);

        private native void native_setDamping(long var1, float var3);

        private native void native_setInvMass(long var1, String var3, float var4);

        private native void native_setSphereCollider(long var1, int var3, Vec3 var4, float var5);

        private native void native_setConstraint(long var1, String var3, String var4, float var5);

        private native void native_setBonesInMvSpace(long var1, boolean var3);

        private native void native_reset(long var1);

        static {
            $assertionsDisabled = PhysicsSimulator.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setGravity(Vec3 vec3) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setGravity(cppProxy.nativeRef, vec3);
        }

        @Override
        public void setDamping(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setDamping(cppProxy.nativeRef, f);
        }

        @Override
        public void setInvMass(String string, float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setInvMass(cppProxy.nativeRef, string, f);
        }

        @Override
        public void setSphereCollider(int n, Vec3 vec3, float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setSphereCollider(cppProxy.nativeRef, n, vec3, f);
        }

        @Override
        public void setConstraint(String string, String string2, float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setConstraint(cppProxy.nativeRef, string, string2, f);
        }

        @Override
        public void setBonesInMvSpace(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setBonesInMvSpace(cppProxy.nativeRef, bl);
        }

        @Override
        public void reset() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_reset(cppProxy.nativeRef);
        }
    }
}

