/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.CameraComposer;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.ProceduralAlgorithmType;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface ProceduralTexture {
    @NonNull
    public ProceduralAlgorithmType getAlgorithmType();

    public void setSrcImage(@Nullable Image var1);

    @Nullable
    public Image getSrcImage();

    @Nullable
    public Image asImage();

    @Nullable
    public CameraComposer asCameraComposer();

    @Keep
    public static final class CppProxy
    implements ProceduralTexture {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native ProceduralAlgorithmType native_getAlgorithmType(long var1);

        private native void native_setSrcImage(long var1, Image var3);

        private native Image native_getSrcImage(long var1);

        private native Image native_asImage(long var1);

        private native CameraComposer native_asCameraComposer(long var1);

        static {
            $assertionsDisabled = ProceduralTexture.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public ProceduralAlgorithmType getAlgorithmType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAlgorithmType(cppProxy.nativeRef);
        }

        @Override
        public void setSrcImage(Image image) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setSrcImage(cppProxy.nativeRef, image);
        }

        @Override
        public Image getSrcImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSrcImage(cppProxy.nativeRef);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }

        @Override
        public CameraComposer asCameraComposer() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asCameraComposer(cppProxy.nativeRef);
        }
    }
}

