/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface RenderInfo {
    public static int getFrxVersion() {
        return CppProxy.getFrxVersion();
    }

    @NonNull
    public static String getPlatform() {
        return CppProxy.getPlatform();
    }

    @NonNull
    public static String getEngineVersion() {
        return CppProxy.getEngineVersion();
    }

    @Keep
    public static final class CppProxy
    implements RenderInfo {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        public static native int getFrxVersion();

        @NonNull
        public static native String getPlatform();

        @NonNull
        public static native String getEngineVersion();

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }
    }
}

