/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Layer;
import com.banuba.sdk.scene.RenderTarget;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface RenderList {
    @Nullable
    public static RenderList create(@NonNull String string) {
        return CppProxy.create(string);
    }

    public void setName(@NonNull String var1);

    @NonNull
    public String getName();

    public long getTasksCount();

    public int addTask(@Nullable Layer var1, @Nullable RenderTarget var2, @Nullable ArrayList<String> var3);

    public void addBlitTargetToTask(@Nullable RenderTarget var1, int var2);

    @Nullable
    public Layer getTaskLayer(int var1);

    @NonNull
    public ArrayList<String> getTaskSubGeometries(int var1);

    @Nullable
    public RenderTarget getTaskTarget(int var1);

    public void clear();

    @Keep
    public static final class CppProxy
    implements RenderList {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setName(long var1, String var3);

        private native String native_getName(long var1);

        private native long native_getTasksCount(long var1);

        private native int native_addTask(long var1, Layer var3, RenderTarget var4, ArrayList<String> var5);

        private native void native_addBlitTargetToTask(long var1, RenderTarget var3, int var4);

        private native Layer native_getTaskLayer(long var1, int var3);

        private native ArrayList<String> native_getTaskSubGeometries(long var1, int var3);

        private native RenderTarget native_getTaskTarget(long var1, int var3);

        private native void native_clear(long var1);

        @Nullable
        public static native RenderList create(@NonNull String var0);

        static {
            $assertionsDisabled = RenderList.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setName(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setName(cppProxy.nativeRef, string);
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public long getTasksCount() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTasksCount(cppProxy.nativeRef);
        }

        @Override
        public int addTask(Layer layer, RenderTarget renderTarget, ArrayList<String> arrayList) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_addTask(cppProxy.nativeRef, layer, renderTarget, arrayList);
        }

        @Override
        public void addBlitTargetToTask(RenderTarget renderTarget, int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addBlitTargetToTask(cppProxy.nativeRef, renderTarget, n);
        }

        @Override
        public Layer getTaskLayer(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTaskLayer(cppProxy.nativeRef, n);
        }

        @Override
        public ArrayList<String> getTaskSubGeometries(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTaskSubGeometries(cppProxy.nativeRef, n);
        }

        @Override
        public RenderTarget getTaskTarget(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTaskTarget(cppProxy.nativeRef, n);
        }

        @Override
        public void clear() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_clear(cppProxy.nativeRef);
        }
    }
}

