/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Image;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface RenderTarget {
    @NonNull
    public String getName();

    public void setSamplesCount(int var1);

    public int getSamplesCount();

    public void setExtent(int var1, int var2);

    public int getWidth();

    public int getHeight();

    public void setScale(float var1);

    public float getScale();

    public void addAttachment(@Nullable Image var1);

    public void removeAttachment(@Nullable Image var1);

    @NonNull
    public ArrayList<Image> getAttachments();

    public void requestReadPixel(int var1, int var2);

    @Keep
    public static final class CppProxy
    implements RenderTarget {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_getName(long var1);

        private native void native_setSamplesCount(long var1, int var3);

        private native int native_getSamplesCount(long var1);

        private native void native_setExtent(long var1, int var3, int var4);

        private native int native_getWidth(long var1);

        private native int native_getHeight(long var1);

        private native void native_setScale(long var1, float var3);

        private native float native_getScale(long var1);

        private native void native_addAttachment(long var1, Image var3);

        private native void native_removeAttachment(long var1, Image var3);

        private native ArrayList<Image> native_getAttachments(long var1);

        private native void native_requestReadPixel(long var1, int var3, int var4);

        static {
            $assertionsDisabled = RenderTarget.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public void setSamplesCount(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setSamplesCount(cppProxy.nativeRef, n);
        }

        @Override
        public int getSamplesCount() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSamplesCount(cppProxy.nativeRef);
        }

        @Override
        public void setExtent(int n, int n2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setExtent(cppProxy.nativeRef, n, n2);
        }

        @Override
        public int getWidth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getWidth(cppProxy.nativeRef);
        }

        @Override
        public int getHeight() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHeight(cppProxy.nativeRef);
        }

        @Override
        public void setScale(float f) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setScale(cppProxy.nativeRef, f);
        }

        @Override
        public float getScale() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getScale(cppProxy.nativeRef);
        }

        @Override
        public void addAttachment(Image image) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addAttachment(cppProxy.nativeRef, image);
        }

        @Override
        public void removeAttachment(Image image) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeAttachment(cppProxy.nativeRef, image);
        }

        @Override
        public ArrayList<Image> getAttachments() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAttachments(cppProxy.nativeRef);
        }

        @Override
        public void requestReadPixel(int n, int n2) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_requestReadPixel(cppProxy.nativeRef, n, n2);
        }
    }
}

