/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.AssetManager;
import com.banuba.sdk.scene.Camera;
import com.banuba.sdk.scene.Component;
import com.banuba.sdk.scene.ComponentType;
import com.banuba.sdk.scene.Entity;
import com.banuba.sdk.scene.Layer;
import com.banuba.sdk.scene.Parameter;
import com.banuba.sdk.scene.RenderList;
import com.banuba.sdk.scene.TriggerStatusType;
import com.banuba.sdk.scene.TriggerType;
import com.banuba.sdk.types.FeatureId;
import com.banuba.sdk.types.FeatureParameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Scene {
    public void setName(@NonNull String var1);

    @NonNull
    public String getName();

    @Nullable
    public Entity getRoot();

    @Nullable
    public AssetManager getAssetManager();

    public void addLayer(@Nullable Layer var1);

    @NonNull
    public ArrayList<Layer> getLayers();

    @NonNull
    public ArrayList<Component> getComponents(@NonNull ComponentType var1);

    @Nullable
    public Layer getLayer(@NonNull String var1);

    public void removeLayer(@Nullable Layer var1);

    public void setRenderList(@Nullable RenderList var1);

    @Nullable
    public RenderList getRenderList();

    public void clearRenderList();

    @Nullable
    public Camera getCamera();

    public void enableRecognizerFeature(@NonNull FeatureId var1);

    public void disableRecognizerFeature(@NonNull FeatureId var1);

    public void addFeatureParam(@NonNull FeatureId var1, @NonNull ArrayList<FeatureParameter> var2);

    public void addEffectEvent(@NonNull String var1, @NonNull HashMap<String, String> var2);

    @NonNull
    public TriggerStatusType getTriggerStatus(@NonNull TriggerType var1);

    @Nullable
    public Entity createEntity(@NonNull String var1);

    public long getNativeContext();

    public int getSurfaceWidth();

    public int getSurfaceHeight();

    @Nullable
    public Parameter findGlobalMaterialParameter(@NonNull String var1);

    @Keep
    public static final class CppProxy
    implements Scene {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_setName(long var1, String var3);

        private native String native_getName(long var1);

        private native Entity native_getRoot(long var1);

        private native AssetManager native_getAssetManager(long var1);

        private native void native_addLayer(long var1, Layer var3);

        private native ArrayList<Layer> native_getLayers(long var1);

        private native ArrayList<Component> native_getComponents(long var1, ComponentType var3);

        private native Layer native_getLayer(long var1, String var3);

        private native void native_removeLayer(long var1, Layer var3);

        private native void native_setRenderList(long var1, RenderList var3);

        private native RenderList native_getRenderList(long var1);

        private native void native_clearRenderList(long var1);

        private native Camera native_getCamera(long var1);

        private native void native_enableRecognizerFeature(long var1, FeatureId var3);

        private native void native_disableRecognizerFeature(long var1, FeatureId var3);

        private native void native_addFeatureParam(long var1, FeatureId var3, ArrayList<FeatureParameter> var4);

        private native void native_addEffectEvent(long var1, String var3, HashMap<String, String> var4);

        private native TriggerStatusType native_getTriggerStatus(long var1, TriggerType var3);

        private native Entity native_createEntity(long var1, String var3);

        private native long native_getNativeContext(long var1);

        private native int native_getSurfaceWidth(long var1);

        private native int native_getSurfaceHeight(long var1);

        private native Parameter native_findGlobalMaterialParameter(long var1, String var3);

        static {
            $assertionsDisabled = Scene.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void setName(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setName(cppProxy.nativeRef, string);
        }

        @Override
        public String getName() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getName(cppProxy.nativeRef);
        }

        @Override
        public Entity getRoot() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getRoot(cppProxy.nativeRef);
        }

        @Override
        public AssetManager getAssetManager() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAssetManager(cppProxy.nativeRef);
        }

        @Override
        public void addLayer(Layer layer) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addLayer(cppProxy.nativeRef, layer);
        }

        @Override
        public ArrayList<Layer> getLayers() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLayers(cppProxy.nativeRef);
        }

        @Override
        public ArrayList<Component> getComponents(ComponentType componentType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getComponents(cppProxy.nativeRef, componentType);
        }

        @Override
        public Layer getLayer(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLayer(cppProxy.nativeRef, string);
        }

        @Override
        public void removeLayer(Layer layer) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_removeLayer(cppProxy.nativeRef, layer);
        }

        @Override
        public void setRenderList(RenderList renderList) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setRenderList(cppProxy.nativeRef, renderList);
        }

        @Override
        public RenderList getRenderList() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getRenderList(cppProxy.nativeRef);
        }

        @Override
        public void clearRenderList() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_clearRenderList(cppProxy.nativeRef);
        }

        @Override
        public Camera getCamera() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getCamera(cppProxy.nativeRef);
        }

        @Override
        public void enableRecognizerFeature(FeatureId featureId) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_enableRecognizerFeature(cppProxy.nativeRef, featureId);
        }

        @Override
        public void disableRecognizerFeature(FeatureId featureId) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_disableRecognizerFeature(cppProxy.nativeRef, featureId);
        }

        @Override
        public void addFeatureParam(FeatureId featureId, ArrayList<FeatureParameter> arrayList) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFeatureParam(cppProxy.nativeRef, featureId, arrayList);
        }

        @Override
        public void addEffectEvent(String string, HashMap<String, String> hashMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addEffectEvent(cppProxy.nativeRef, string, hashMap);
        }

        @Override
        public TriggerStatusType getTriggerStatus(TriggerType triggerType) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTriggerStatus(cppProxy.nativeRef, triggerType);
        }

        @Override
        public Entity createEntity(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_createEntity(cppProxy.nativeRef, string);
        }

        @Override
        public long getNativeContext() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getNativeContext(cppProxy.nativeRef);
        }

        @Override
        public int getSurfaceWidth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSurfaceWidth(cppProxy.nativeRef);
        }

        @Override
        public int getSurfaceHeight() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSurfaceHeight(cppProxy.nativeRef);
        }

        @Override
        public Parameter findGlobalMaterialParameter(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_findGlobalMaterialParameter(cppProxy.nativeRef, string);
        }
    }
}

