/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.SegmentationMaskType;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface SegmentationMask {
    @NonNull
    public SegmentationMaskType getMaskType();

    public void setActive(boolean var1);

    public boolean isActive();

    @Nullable
    public Image asImage();

    @Keep
    public static final class CppProxy
    implements SegmentationMask {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native SegmentationMaskType native_getMaskType(long var1);

        private native void native_setActive(long var1, boolean var3);

        private native boolean native_isActive(long var1);

        private native Image native_asImage(long var1);

        static {
            $assertionsDisabled = SegmentationMask.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public SegmentationMaskType getMaskType() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMaskType(cppProxy.nativeRef);
        }

        @Override
        public void setActive(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setActive(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean isActive() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_isActive(cppProxy.nativeRef);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }
    }
}

