/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.Resource;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface TextTexture {
    public void loadResource(@Nullable Resource var1);

    public int getWidth();

    public int getHeight();

    public void setWidth(int var1);

    public void setHeight(int var1);

    public void setText(@NonNull String var1);

    @NonNull
    public String getText();

    public void setFont(@NonNull String var1);

    @NonNull
    public String getFont();

    @Nullable
    public Image asImage();

    @Keep
    public static final class CppProxy
    implements TextTexture {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_loadResource(long var1, Resource var3);

        private native int native_getWidth(long var1);

        private native int native_getHeight(long var1);

        private native void native_setWidth(long var1, int var3);

        private native void native_setHeight(long var1, int var3);

        private native void native_setText(long var1, String var3);

        private native String native_getText(long var1);

        private native void native_setFont(long var1, String var3);

        private native String native_getFont(long var1);

        private native Image native_asImage(long var1);

        static {
            $assertionsDisabled = TextTexture.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void loadResource(Resource resource) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_loadResource(cppProxy.nativeRef, resource);
        }

        @Override
        public int getWidth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getWidth(cppProxy.nativeRef);
        }

        @Override
        public int getHeight() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHeight(cppProxy.nativeRef);
        }

        @Override
        public void setWidth(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setWidth(cppProxy.nativeRef, n);
        }

        @Override
        public void setHeight(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setHeight(cppProxy.nativeRef, n);
        }

        @Override
        public void setText(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setText(cppProxy.nativeRef, string);
        }

        @Override
        public String getText() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getText(cppProxy.nativeRef);
        }

        @Override
        public void setFont(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFont(cppProxy.nativeRef, string);
        }

        @Override
        public String getFont() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFont(cppProxy.nativeRef);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }
    }
}

