/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.Resource;
import com.banuba.sdk.scene.TextureFilteringMode;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Texture {
    public void loadResource(@Nullable Resource var1);

    public void loadByFd(int var1);

    public void load(@NonNull String var1);

    public int getWidth();

    public int getHeight();

    public int getLayers();

    public void setMips(boolean var1);

    public boolean hasMips();

    public void setTiling(boolean var1);

    public boolean getTiling();

    public void setFiltering(@NonNull TextureFilteringMode var1);

    @NonNull
    public TextureFilteringMode getFilteringMode();

    @Nullable
    public Image asImage();

    @Keep
    public static final class CppProxy
    implements Texture {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native void native_loadResource(long var1, Resource var3);

        private native void native_loadByFd(long var1, int var3);

        private native void native_load(long var1, String var3);

        private native int native_getWidth(long var1);

        private native int native_getHeight(long var1);

        private native int native_getLayers(long var1);

        private native void native_setMips(long var1, boolean var3);

        private native boolean native_hasMips(long var1);

        private native void native_setTiling(long var1, boolean var3);

        private native boolean native_getTiling(long var1);

        private native void native_setFiltering(long var1, TextureFilteringMode var3);

        private native TextureFilteringMode native_getFilteringMode(long var1);

        private native Image native_asImage(long var1);

        static {
            $assertionsDisabled = Texture.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public void loadResource(Resource resource) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_loadResource(cppProxy.nativeRef, resource);
        }

        @Override
        public void loadByFd(int n) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_loadByFd(cppProxy.nativeRef, n);
        }

        @Override
        public void load(String string) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_load(cppProxy.nativeRef, string);
        }

        @Override
        public int getWidth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getWidth(cppProxy.nativeRef);
        }

        @Override
        public int getHeight() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHeight(cppProxy.nativeRef);
        }

        @Override
        public int getLayers() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLayers(cppProxy.nativeRef);
        }

        @Override
        public void setMips(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setMips(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean hasMips() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_hasMips(cppProxy.nativeRef);
        }

        @Override
        public void setTiling(boolean bl) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setTiling(cppProxy.nativeRef, bl);
        }

        @Override
        public boolean getTiling() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTiling(cppProxy.nativeRef);
        }

        @Override
        public void setFiltering(TextureFilteringMode textureFilteringMode) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFiltering(cppProxy.nativeRef, textureFilteringMode);
        }

        @Override
        public TextureFilteringMode getFilteringMode() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFilteringMode(cppProxy.nativeRef);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }
    }
}

