/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.scene;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.scene.Image;
import com.banuba.sdk.scene.Media;
import com.banuba.sdk.scene.TextureFilteringMode;
import com.banuba.sdk.scene.VideoLoadingResultListener;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Video {
    @NonNull
    public String getCurrentVideo();

    public int getWidth();

    public int getHeight();

    public void load(@NonNull String var1, @Nullable VideoLoadingResultListener var2);

    public void loadByFd(int var1, @Nullable VideoLoadingResultListener var2);

    @Nullable
    public Media asMedia();

    @Nullable
    public Image asImage();

    public float getRotationAngle();

    public void setFilteringMode(@NonNull TextureFilteringMode var1);

    @NonNull
    public TextureFilteringMode getFilteringMode();

    @Keep
    public static final class CppProxy
    implements Video {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native String native_getCurrentVideo(long var1);

        private native int native_getWidth(long var1);

        private native int native_getHeight(long var1);

        private native void native_load(long var1, String var3, VideoLoadingResultListener var4);

        private native void native_loadByFd(long var1, int var3, VideoLoadingResultListener var4);

        private native Media native_asMedia(long var1);

        private native Image native_asImage(long var1);

        private native float native_getRotationAngle(long var1);

        private native void native_setFilteringMode(long var1, TextureFilteringMode var3);

        private native TextureFilteringMode native_getFilteringMode(long var1);

        static {
            $assertionsDisabled = Video.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getCurrentVideo() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getCurrentVideo(cppProxy.nativeRef);
        }

        @Override
        public int getWidth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getWidth(cppProxy.nativeRef);
        }

        @Override
        public int getHeight() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHeight(cppProxy.nativeRef);
        }

        @Override
        public void load(String string, VideoLoadingResultListener videoLoadingResultListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_load(cppProxy.nativeRef, string, videoLoadingResultListener);
        }

        @Override
        public void loadByFd(int n, VideoLoadingResultListener videoLoadingResultListener) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_loadByFd(cppProxy.nativeRef, n, videoLoadingResultListener);
        }

        @Override
        public Media asMedia() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asMedia(cppProxy.nativeRef);
        }

        @Override
        public Image asImage() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_asImage(cppProxy.nativeRef);
        }

        @Override
        public float getRotationAngle() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getRotationAngle(cppProxy.nativeRef);
        }

        @Override
        public void setFilteringMode(TextureFilteringMode textureFilteringMode) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFilteringMode(cppProxy.nativeRef, textureFilteringMode);
        }

        @Override
        public TextureFilteringMode getFilteringMode() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFilteringMode(cppProxy.nativeRef);
        }
    }
}

