/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.types;

import androidx.annotation.Keep;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public class Data
implements Closeable {
    private final long nativeRef;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private ByteBuffer data;

    public Data(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            Data data = this;
            data.data = byteBuffer;
            data.nativeRef = 0L;
            return;
        }
        throw new IllegalArgumentException("buffer is not directly allocated");
    }

    private Data(long l, ByteBuffer byteBuffer) {
        if (l != 0L) {
            Data data = this;
            data.nativeRef = l;
            data.data = byteBuffer;
            return;
        }
        throw new IllegalArgumentException("nativeRef is zero");
    }

    private native void nativeDestroy(long var1);

    @Override
    public void close() {
        Data data = this;
        boolean bl = data.destroyed.getAndSet(true);
        long l = data.nativeRef;
        if (l == 0L) {
            return;
        }
        if (!bl) {
            this.nativeDestroy(l);
        }
    }

    protected void finalize() {
        if (this.destroyed.get()) {
            super.finalize();
            return;
        }
        throw new RuntimeException("object not closed!");
    }

    public ByteBuffer getData() {
        if (!this.destroyed.get()) {
            return this.data;
        }
        throw new RuntimeException("trying to use a closed object");
    }
}

