/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.types;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.types.AcneRegions;
import com.banuba.sdk.types.ActionUnitsData;
import com.banuba.sdk.types.BrowsMask;
import com.banuba.sdk.types.DepthMap;
import com.banuba.sdk.types.ExternalFaceData;
import com.banuba.sdk.types.EyesMask;
import com.banuba.sdk.types.EyesState;
import com.banuba.sdk.types.FaceDataSource;
import com.banuba.sdk.types.FeatureId;
import com.banuba.sdk.types.FeatureParameter;
import com.banuba.sdk.types.FrxRecognitionResult;
import com.banuba.sdk.types.FullImageData;
import com.banuba.sdk.types.FullImageFormat;
import com.banuba.sdk.types.LipsShineMask;
import com.banuba.sdk.types.TransformedMaskByte;
import com.banuba.sdk.types.TransformedMaskGpu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface FrameData {
    @Nullable
    public static FrameData create() {
        return CppProxy.create();
    }

    @NonNull
    public FullImageFormat getFullImgFormat();

    @NonNull
    public ArrayList<Float> getFullImgTransform();

    @Nullable
    public FrxRecognitionResult getFrxRecognitionResult();

    public void setFrxRecognitionResult(@Nullable FrxRecognitionResult var1);

    @NonNull
    public ActionUnitsData getActionUnits();

    @NonNull
    public AcneRegions getAcneRegions();

    public boolean getIsSmile();

    public boolean getIsMouthOpen();

    public boolean getIsBrowsRaised();

    public boolean getIsBrowsShifted();

    public boolean getIsWearGlasses();

    public float getRuler();

    @NonNull
    public EyesState getEyesState();

    public float getLightCorrection();

    @NonNull
    public TransformedMaskByte getBackground();

    @NonNull
    public TransformedMaskGpu getBackgroundGpu();

    @NonNull
    public TransformedMaskByte getHair();

    @NonNull
    public TransformedMaskGpu getHairGpu();

    @NonNull
    public TransformedMaskByte getSkin();

    @NonNull
    public TransformedMaskGpu getSkinGpu();

    @NonNull
    public TransformedMaskByte getLips();

    @NonNull
    public TransformedMaskGpu getLipsGpu();

    @NonNull
    public TransformedMaskByte getTeeth();

    @NonNull
    public TransformedMaskByte getOcclusion();

    @NonNull
    public TransformedMaskByte getBody();

    @NonNull
    public LipsShineMask getLipsShine();

    @NonNull
    public BrowsMask getBrows();

    @NonNull
    public EyesMask getEyes();

    @NonNull
    public TransformedMaskByte getFace();

    @NonNull
    public TransformedMaskByte getFaceSkin();

    @Nullable
    public String getFaceAttributes();

    public float getPupillaryDistance();

    public void addFullImg(@NonNull FullImageData var1);

    public void replaceFullImg(@NonNull FullImageData var1);

    public void addBackground(@NonNull TransformedMaskByte var1);

    public void addExternalFaceData(@NonNull FaceDataSource var1, @NonNull ArrayList<ExternalFaceData> var2);

    public void addDepthMap(@NonNull DepthMap var1);

    public void addFrameNumber(long var1);

    public void addActionUnitsData(@NonNull ActionUnitsData var1);

    public void addFeatureParameters(@NonNull HashMap<FeatureId, ArrayList<FeatureParameter>> var1);

    public void addTimestampUs(double var1);

    @Keep
    public static final class CppProxy
    implements FrameData {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native FullImageFormat native_getFullImgFormat(long var1);

        private native ArrayList<Float> native_getFullImgTransform(long var1);

        private native FrxRecognitionResult native_getFrxRecognitionResult(long var1);

        private native void native_setFrxRecognitionResult(long var1, FrxRecognitionResult var3);

        private native ActionUnitsData native_getActionUnits(long var1);

        private native AcneRegions native_getAcneRegions(long var1);

        private native boolean native_getIsSmile(long var1);

        private native boolean native_getIsMouthOpen(long var1);

        private native boolean native_getIsBrowsRaised(long var1);

        private native boolean native_getIsBrowsShifted(long var1);

        private native boolean native_getIsWearGlasses(long var1);

        private native float native_getRuler(long var1);

        private native EyesState native_getEyesState(long var1);

        private native float native_getLightCorrection(long var1);

        private native TransformedMaskByte native_getBackground(long var1);

        private native TransformedMaskGpu native_getBackgroundGpu(long var1);

        private native TransformedMaskByte native_getHair(long var1);

        private native TransformedMaskGpu native_getHairGpu(long var1);

        private native TransformedMaskByte native_getSkin(long var1);

        private native TransformedMaskGpu native_getSkinGpu(long var1);

        private native TransformedMaskByte native_getLips(long var1);

        private native TransformedMaskGpu native_getLipsGpu(long var1);

        private native TransformedMaskByte native_getTeeth(long var1);

        private native TransformedMaskByte native_getOcclusion(long var1);

        private native TransformedMaskByte native_getBody(long var1);

        private native LipsShineMask native_getLipsShine(long var1);

        private native BrowsMask native_getBrows(long var1);

        private native EyesMask native_getEyes(long var1);

        private native TransformedMaskByte native_getFace(long var1);

        private native TransformedMaskByte native_getFaceSkin(long var1);

        private native String native_getFaceAttributes(long var1);

        private native float native_getPupillaryDistance(long var1);

        private native void native_addFullImg(long var1, FullImageData var3);

        private native void native_replaceFullImg(long var1, FullImageData var3);

        private native void native_addBackground(long var1, TransformedMaskByte var3);

        private native void native_addExternalFaceData(long var1, FaceDataSource var3, ArrayList<ExternalFaceData> var4);

        private native void native_addDepthMap(long var1, DepthMap var3);

        private native void native_addFrameNumber(long var1, long var3);

        private native void native_addActionUnitsData(long var1, ActionUnitsData var3);

        private native void native_addFeatureParameters(long var1, HashMap<FeatureId, ArrayList<FeatureParameter>> var3);

        private native void native_addTimestampUs(long var1, double var3);

        @Nullable
        public static native FrameData create();

        static {
            $assertionsDisabled = FrameData.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public FullImageFormat getFullImgFormat() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFullImgFormat(cppProxy.nativeRef);
        }

        @Override
        public ArrayList<Float> getFullImgTransform() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFullImgTransform(cppProxy.nativeRef);
        }

        @Override
        public FrxRecognitionResult getFrxRecognitionResult() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFrxRecognitionResult(cppProxy.nativeRef);
        }

        @Override
        public void setFrxRecognitionResult(FrxRecognitionResult frxRecognitionResult) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFrxRecognitionResult(cppProxy.nativeRef, frxRecognitionResult);
        }

        @Override
        public ActionUnitsData getActionUnits() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getActionUnits(cppProxy.nativeRef);
        }

        @Override
        public AcneRegions getAcneRegions() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getAcneRegions(cppProxy.nativeRef);
        }

        @Override
        public boolean getIsSmile() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getIsSmile(cppProxy.nativeRef);
        }

        @Override
        public boolean getIsMouthOpen() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getIsMouthOpen(cppProxy.nativeRef);
        }

        @Override
        public boolean getIsBrowsRaised() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getIsBrowsRaised(cppProxy.nativeRef);
        }

        @Override
        public boolean getIsBrowsShifted() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getIsBrowsShifted(cppProxy.nativeRef);
        }

        @Override
        public boolean getIsWearGlasses() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getIsWearGlasses(cppProxy.nativeRef);
        }

        @Override
        public float getRuler() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getRuler(cppProxy.nativeRef);
        }

        @Override
        public EyesState getEyesState() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getEyesState(cppProxy.nativeRef);
        }

        @Override
        public float getLightCorrection() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLightCorrection(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getBackground() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBackground(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskGpu getBackgroundGpu() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBackgroundGpu(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getHair() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHair(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskGpu getHairGpu() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getHairGpu(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getSkin() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSkin(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskGpu getSkinGpu() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getSkinGpu(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getLips() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLips(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskGpu getLipsGpu() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLipsGpu(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getTeeth() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTeeth(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getOcclusion() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getOcclusion(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getBody() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBody(cppProxy.nativeRef);
        }

        @Override
        public LipsShineMask getLipsShine() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getLipsShine(cppProxy.nativeRef);
        }

        @Override
        public BrowsMask getBrows() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getBrows(cppProxy.nativeRef);
        }

        @Override
        public EyesMask getEyes() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getEyes(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getFace() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFace(cppProxy.nativeRef);
        }

        @Override
        public TransformedMaskByte getFaceSkin() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFaceSkin(cppProxy.nativeRef);
        }

        @Override
        public String getFaceAttributes() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFaceAttributes(cppProxy.nativeRef);
        }

        @Override
        public float getPupillaryDistance() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getPupillaryDistance(cppProxy.nativeRef);
        }

        @Override
        public void addFullImg(FullImageData fullImageData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFullImg(cppProxy.nativeRef, fullImageData);
        }

        @Override
        public void replaceFullImg(FullImageData fullImageData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_replaceFullImg(cppProxy.nativeRef, fullImageData);
        }

        @Override
        public void addBackground(TransformedMaskByte transformedMaskByte) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addBackground(cppProxy.nativeRef, transformedMaskByte);
        }

        @Override
        public void addExternalFaceData(FaceDataSource faceDataSource, ArrayList<ExternalFaceData> arrayList) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addExternalFaceData(cppProxy.nativeRef, faceDataSource, arrayList);
        }

        @Override
        public void addDepthMap(DepthMap depthMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addDepthMap(cppProxy.nativeRef, depthMap);
        }

        @Override
        public void addFrameNumber(long l) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFrameNumber(cppProxy.nativeRef, l);
        }

        @Override
        public void addActionUnitsData(ActionUnitsData actionUnitsData) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addActionUnitsData(cppProxy.nativeRef, actionUnitsData);
        }

        @Override
        public void addFeatureParameters(HashMap<FeatureId, ArrayList<FeatureParameter>> hashMap) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addFeatureParameters(cppProxy.nativeRef, hashMap);
        }

        @Override
        public void addTimestampUs(double d) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_addTimestampUs(cppProxy.nativeRef, d);
        }
    }
}

