/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.types;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.types.FaceData;
import com.banuba.sdk.types.TransformableEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface FrxRecognitionResult {
    @Nullable
    public static FrxRecognitionResult create() {
        return CppProxy.create();
    }

    @NonNull
    public ArrayList<FaceData> getFaces();

    public void setFaces(@NonNull ArrayList<FaceData> var1);

    @NonNull
    public ArrayList<Float> getTexCoords();

    @NonNull
    public ArrayList<Integer> getTriangles();

    @NonNull
    public TransformableEvent getTransform();

    public void setTransform(@NonNull TransformableEvent var1);

    @Keep
    public static final class CppProxy
    implements FrxRecognitionResult {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native ArrayList<FaceData> native_getFaces(long var1);

        private native void native_setFaces(long var1, ArrayList<FaceData> var3);

        private native ArrayList<Float> native_getTexCoords(long var1);

        private native ArrayList<Integer> native_getTriangles(long var1);

        private native TransformableEvent native_getTransform(long var1);

        private native void native_setTransform(long var1, TransformableEvent var3);

        @Nullable
        public static native FrxRecognitionResult create();

        static {
            $assertionsDisabled = FrxRecognitionResult.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public ArrayList<FaceData> getFaces() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getFaces(cppProxy.nativeRef);
        }

        @Override
        public void setFaces(ArrayList<FaceData> arrayList) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setFaces(cppProxy.nativeRef, arrayList);
        }

        @Override
        public ArrayList<Float> getTexCoords() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTexCoords(cppProxy.nativeRef);
        }

        @Override
        public ArrayList<Integer> getTriangles() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTriangles(cppProxy.nativeRef);
        }

        @Override
        public TransformableEvent getTransform() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getTransform(cppProxy.nativeRef);
        }

        @Override
        public void setTransform(TransformableEvent transformableEvent) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_setTransform(cppProxy.nativeRef, transformableEvent);
        }
    }
}

