/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.types;

import android.graphics.Bitmap;
import android.media.Image;
import android.util.Size;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.banuba.sdk.effect_player.CameraOrientation;
import com.banuba.sdk.effect_player.ColorRange;
import com.banuba.sdk.effect_player.ColorStd;
import com.banuba.sdk.utils.ImageReleaser;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@Keep
public class FullImageData {
    private final int width;
    private final int height;
    private final CameraOrientation cameraOrientation;
    private final boolean requireMirroring;
    private final int faceOrientation;
    private ColorRange colorRange;
    private ColorStd colorStd;
    private final Buffer plane0;
    private final Buffer plane1;
    private final Buffer plane2;
    private final int rowStride0;
    private final int rowStride1;
    private final int rowStride2;
    private final int pixelStride0;
    private final int pixelStride1;
    private final int pixelStride2;
    private final int pixelFormat;
    ImageReleaser imageReleaser;

    public FullImageData(Image image, Orientation orientation) {
        block4: {
            block3: {
                Image.Plane[] planeArray;
                block2: {
                    this.colorRange = ColorRange.FULL;
                    this.colorStd = ColorStd.BT601;
                    this.imageReleaser = null;
                    planeArray = image.getPlanes();
                    if (planeArray == null || planeArray.length < 3) break block2;
                    Orientation orientation2 = orientation;
                    Image image2 = image;
                    this.width = image2.getWidth();
                    this.height = image2.getHeight();
                    this.cameraOrientation = orientation2.getCameraOrientation();
                    this.faceOrientation = orientation2.getFaceOrientation();
                    this.requireMirroring = orientation2.isRequireMirroring();
                    this.plane0 = planeArray[0].getBuffer();
                    this.plane1 = planeArray[1].getBuffer();
                    this.plane2 = planeArray[2].getBuffer();
                    this.rowStride0 = planeArray[0].getRowStride();
                    this.rowStride1 = planeArray[1].getRowStride();
                    this.rowStride2 = planeArray[2].getRowStride();
                    this.pixelStride0 = planeArray[0].getPixelStride();
                    this.pixelStride1 = planeArray[1].getPixelStride();
                    this.pixelStride2 = planeArray[2].getPixelStride();
                    this.pixelFormat = image.getFormat();
                    break block3;
                }
                if (planeArray == null || planeArray.length != 1) break block4;
                Orientation orientation3 = orientation;
                Image image3 = image;
                this.width = image3.getWidth();
                this.height = image3.getHeight();
                this.cameraOrientation = orientation3.getCameraOrientation();
                this.faceOrientation = orientation3.getFaceOrientation();
                this.requireMirroring = orientation3.isRequireMirroring();
                this.plane0 = planeArray[0].getBuffer();
                this.plane1 = null;
                this.plane2 = null;
                this.rowStride0 = planeArray[0].getRowStride();
                this.rowStride1 = 0;
                this.rowStride2 = 0;
                this.pixelStride0 = planeArray[0].getPixelStride();
                this.pixelStride1 = 0;
                this.pixelStride2 = 0;
                this.pixelFormat = image.getFormat();
            }
            return;
        }
        throw new IllegalArgumentException("Invalid image");
    }

    public FullImageData(Image image, Orientation orientation, ImageReleaser imageReleaser) {
        this(image, orientation);
        this.imageReleaser = imageReleaser;
    }

    public FullImageData(Image image, Orientation orientation, ImageReleaser imageReleaser, ColorRange colorRange, ColorStd colorStd) {
        this(image, orientation, imageReleaser);
        this.colorRange = colorRange;
        this.colorStd = colorStd;
    }

    public FullImageData(Size size, Buffer buffer, Buffer buffer2, Buffer buffer3, int n, int n2, int n3, int n4, int n5, int n6, Orientation orientation) {
        FullImageData fullImageData = this;
        this.colorRange = ColorRange.FULL;
        this.colorStd = ColorStd.BT601;
        this.imageReleaser = null;
        this.width = size.getWidth();
        this.height = size.getHeight();
        this.plane0 = buffer;
        this.plane1 = buffer2;
        this.plane2 = buffer3;
        this.rowStride0 = n;
        this.rowStride1 = n2;
        this.rowStride2 = n3;
        this.pixelStride0 = n4;
        this.pixelStride1 = n5;
        fullImageData.pixelStride2 = n6;
        fullImageData.pixelFormat = 35;
        this.cameraOrientation = orientation.getCameraOrientation();
        this.faceOrientation = orientation.getFaceOrientation();
        this.requireMirroring = orientation.isRequireMirroring();
    }

    public FullImageData(Size size, Buffer buffer, Buffer buffer2, Buffer buffer3, int n, int n2, int n3, int n4, int n5, int n6, Orientation orientation, ImageReleaser imageReleaser) {
        this(size, buffer, buffer2, buffer3, n, n2, n3, n4, n5, n6, orientation);
        this.imageReleaser = imageReleaser;
    }

    public FullImageData(Size size, Buffer buffer, Buffer buffer2, Buffer buffer3, int n, int n2, int n3, int n4, int n5, int n6, Orientation orientation, ImageReleaser imageReleaser, ColorRange colorRange, ColorStd colorStd) {
        this(size, buffer, buffer2, buffer3, n, n2, n3, n4, n5, n6, orientation, imageReleaser);
        this.colorRange = colorRange;
        this.colorStd = colorStd;
    }

    public FullImageData(Bitmap bitmap, Orientation orientation) {
        this.colorRange = ColorRange.FULL;
        this.colorStd = ColorStd.BT601;
        this.imageReleaser = null;
        if (bitmap.getConfig() == Bitmap.Config.ARGB_8888) {
            int n;
            FullImageData fullImageData = this;
            FullImageData fullImageData2 = this;
            Bitmap bitmap2 = bitmap;
            this.width = bitmap.getWidth();
            this.height = n = bitmap.getHeight();
            this.cameraOrientation = orientation.getCameraOrientation();
            this.faceOrientation = orientation.getFaceOrientation();
            this.requireMirroring = orientation.isRequireMirroring();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bitmap2.getRowBytes() * n);
            bitmap2.copyPixelsToBuffer((Buffer)byteBuffer);
            fullImageData2.plane0 = byteBuffer;
            fullImageData2.plane1 = null;
            fullImageData2.plane2 = null;
            fullImageData.rowStride0 = bitmap.getRowBytes();
            fullImageData.rowStride1 = 0;
            fullImageData.rowStride2 = 0;
            fullImageData.pixelStride0 = 4;
            fullImageData.pixelStride1 = 0;
            fullImageData.pixelStride2 = 0;
            fullImageData.pixelFormat = 1;
            return;
        }
        throw new RuntimeException("Only ARGB_8888 Bitmap's supported!");
    }

    public FullImageData(Buffer buffer, Size size, int n, Orientation orientation) {
        FullImageData fullImageData = this;
        FullImageData fullImageData2 = this;
        this.colorRange = ColorRange.FULL;
        this.colorStd = ColorStd.BT601;
        this.imageReleaser = null;
        this.width = size.getWidth();
        this.height = size.getHeight();
        this.cameraOrientation = orientation.getCameraOrientation();
        this.faceOrientation = orientation.getFaceOrientation();
        this.requireMirroring = orientation.isRequireMirroring();
        fullImageData2.plane0 = buffer;
        fullImageData2.plane1 = null;
        fullImageData2.plane2 = null;
        fullImageData.rowStride0 = n;
        fullImageData.rowStride1 = 0;
        fullImageData.rowStride2 = 0;
        fullImageData.pixelStride0 = 4;
        fullImageData.pixelStride1 = 0;
        fullImageData.pixelStride2 = 0;
        fullImageData.pixelFormat = 1;
    }

    public void setImageReleaser(ImageReleaser imageReleaser) {
        this.imageReleaser = imageReleaser;
    }

    public Size getSize() {
        FullImageData fullImageData = this;
        int n = fullImageData.width;
        return new Size(n, fullImageData.height);
    }

    public Orientation getOrientation() {
        FullImageData fullImageData = object;
        Object object = fullImageData.cameraOrientation;
        boolean bl = fullImageData.requireMirroring;
        int n = fullImageData.faceOrientation;
        return new Orientation((CameraOrientation)((Object)object), bl, n);
    }

    public int getPixelFormat() {
        return this.pixelFormat;
    }

    @Nullable
    public ColorRange getColorRange() {
        return this.getPixelFormat() == 35 ? this.colorRange : null;
    }

    @Nullable
    public ColorStd getColorStd() {
        return this.getPixelFormat() == 35 ? this.colorStd : null;
    }

    @Keep
    public static class Orientation {
        private final CameraOrientation mCameraOrientation;
        private final boolean mRequireMirroring;
        private final int mFaceOrientation;

        public Orientation(CameraOrientation cameraOrientation, boolean bl, int n) {
            this.mCameraOrientation = cameraOrientation;
            this.mRequireMirroring = bl;
            this.mFaceOrientation = n;
        }

        public Orientation(CameraOrientation cameraOrientation) {
            this(cameraOrientation, false, 0);
        }

        public Orientation() {
            this(CameraOrientation.DEG_0, false, 0);
        }

        public CameraOrientation getCameraOrientation() {
            return this.mCameraOrientation;
        }

        public boolean isRequireMirroring() {
            return this.mRequireMirroring;
        }

        public int getFaceOrientation() {
            return this.mFaceOrientation;
        }
    }
}

