/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.types;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.banuba.sdk.types.PixelRect;
import com.banuba.sdk.types.Point2d;
import com.banuba.sdk.types.Rotation;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface Transformation {
    @Nullable
    public static Transformation makeIdentity() {
        return CppProxy.makeIdentity();
    }

    @Nullable
    public static Transformation makeData(@NonNull ArrayList<Float> arrayList) {
        return CppProxy.makeData(arrayList);
    }

    @Nullable
    public static Transformation makeRot(@NonNull Rotation rotation) {
        return CppProxy.makeRot(rotation);
    }

    @Nullable
    public static Transformation makeAffine(float f, float f2, float f3, float f4, @NonNull Rotation rotation, boolean bl, boolean bl2) {
        return CppProxy.makeAffine(f, f2, f3, f4, rotation, bl, bl2);
    }

    @Nullable
    public static Transformation makeRects(@NonNull PixelRect pixelRect, @NonNull PixelRect pixelRect2, @NonNull Rotation rotation, boolean bl, boolean bl2) {
        return CppProxy.makeRects(pixelRect, pixelRect2, rotation, bl, bl2);
    }

    @Nullable
    public Transformation chainRight(@Nullable Transformation var1);

    @NonNull
    public Point2d transformPoint(@NonNull Point2d var1);

    @NonNull
    public PixelRect transformRect(@NonNull PixelRect var1);

    public boolean equals(@Nullable Transformation var1);

    @Nullable
    public Transformation inverseJ();

    @Nullable
    public Transformation cloneJ();

    @NonNull
    public ArrayList<Float> getMatJ();

    @Keep
    public static final class CppProxy
    implements Transformation {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native Transformation native_chainRight(long var1, Transformation var3);

        private native Point2d native_transformPoint(long var1, Point2d var3);

        private native PixelRect native_transformRect(long var1, PixelRect var3);

        private native boolean native_equals(long var1, Transformation var3);

        private native Transformation native_inverseJ(long var1);

        private native Transformation native_cloneJ(long var1);

        private native ArrayList<Float> native_getMatJ(long var1);

        @Nullable
        public static native Transformation makeIdentity();

        @Nullable
        public static native Transformation makeData(@NonNull ArrayList<Float> var0);

        @Nullable
        public static native Transformation makeRot(@NonNull Rotation var0);

        @Nullable
        public static native Transformation makeAffine(float var0, float var1, float var2, float var3, @NonNull Rotation var4, boolean var5, boolean var6);

        @Nullable
        public static native Transformation makeRects(@NonNull PixelRect var0, @NonNull PixelRect var1, @NonNull Rotation var2, boolean var3, boolean var4);

        static {
            $assertionsDisabled = Transformation.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public Transformation chainRight(Transformation transformation) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_chainRight(cppProxy.nativeRef, transformation);
        }

        @Override
        public Point2d transformPoint(Point2d point2d) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_transformPoint(cppProxy.nativeRef, point2d);
        }

        @Override
        public PixelRect transformRect(PixelRect pixelRect) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_transformRect(cppProxy.nativeRef, pixelRect);
        }

        @Override
        public boolean equals(Transformation transformation) {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_equals(cppProxy.nativeRef, transformation);
        }

        @Override
        public Transformation inverseJ() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_inverseJ(cppProxy.nativeRef);
        }

        @Override
        public Transformation cloneJ() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_cloneJ(cppProxy.nativeRef);
        }

        @Override
        public ArrayList<Float> getMatJ() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_getMatJ(cppProxy.nativeRef);
        }
    }
}

