/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.utils;

import android.os.Trace;
import android.util.Log;
import androidx.annotation.Keep;

@Keep
public final class ATrace
implements AutoCloseable {
    private static final String TAG = "ATrace";
    private static boolean sPrintToLogcat;
    private final String mSectionName;
    private long mStartTime;

    public static void setPrintToLogcat(boolean bl) {
        sPrintToLogcat = bl;
    }

    public ATrace(String string) {
        this.mSectionName = string;
        if (sPrintToLogcat) {
            this.mStartTime = System.currentTimeMillis();
            Log.d((String)TAG, (String)(string + " ===>"));
        }
        Trace.beginSection((String)string);
    }

    @Override
    public void close() {
        Trace.endSection();
        if (sPrintToLogcat) {
            long l = System.currentTimeMillis() - this.mStartTime;
            Log.d((String)TAG, (String)(this.mSectionName + "(" + l + " ms) <==="));
        }
    }
}

