/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

@Keep
public final class ContextProvider {
    @NonNull
    private static WeakReference<Context> sContext = new WeakReference<Object>(null);

    public static void setContext(@NonNull Context context) {
        sContext = new WeakReference<Context>(context.getApplicationContext());
    }

    @Nullable
    public static Context getContext() {
        return (Context)sContext.get();
    }

    @Nullable
    public static AssetManager getAssets() {
        Context context = (Context)sContext.get();
        if (context != null) {
            return context.getAssets();
        }
        ContextProvider.printError();
        return null;
    }

    @NonNull
    public static String getCacheDir() {
        Context context = (Context)sContext.get();
        if (context != null) {
            return context.getCacheDir().getAbsolutePath();
        }
        ContextProvider.printError();
        return "";
    }

    private static void printError() {
        Log.e((String)"ContextProvider", (String)"`Context` is null, call `com.banuba.sdk.utils.ContextProvider.setContext` first.");
    }

    private ContextProvider() {
    }
}

