/*
 * Decompiled with CFR 0.152.
 */
package com.banuba.sdk.utils;

import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public interface EglContext {
    @Nullable
    public static EglContext create(int n, int n2) {
        return CppProxy.create(n, n2);
    }

    public boolean check();

    public void activate();

    public void deactivate();

    @Keep
    public static final class CppProxy
    implements EglContext {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long l) {
            if (l != 0L) {
                this.nativeRef = l;
                return;
            }
            throw new RuntimeException("nativeRef is zero");
        }

        private native void nativeDestroy(long var1);

        private native boolean native_check(long var1);

        private native void native_activate(long var1);

        private native void native_deactivate(long var1);

        @Nullable
        public static native EglContext create(int var0, int var1);

        static {
            $assertionsDisabled = EglContext.class.desiredAssertionStatus() ^ true;
        }

        public void _djinni_private_destroy() {
            if (!this.destroyed.getAndSet(true)) {
                CppProxy cppProxy = this;
                cppProxy.nativeDestroy(cppProxy.nativeRef);
            }
        }

        protected void finalize() {
            CppProxy cppProxy = this;
            cppProxy._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public boolean check() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            return cppProxy.native_check(cppProxy.nativeRef);
        }

        @Override
        public void activate() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_activate(cppProxy.nativeRef);
        }

        @Override
        public void deactivate() {
            if (!$assertionsDisabled && this.destroyed.get()) {
                throw new AssertionError((Object)"trying to use a destroyed object");
            }
            CppProxy cppProxy = this;
            cppProxy.native_deactivate(cppProxy.nativeRef);
        }
    }
}

