/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline;

import co.decodable.sdk.pipeline.util.Incubating;
import java.util.Map;
import java.util.Objects;

@Incubating
public class EnvironmentAccess {
    private static Environment ENVIRONMENT = new SystemEnvironment();

    private EnvironmentAccess() {
    }

    public static synchronized void setEnvironment(Environment environment) {
        Objects.requireNonNull(environment, "Environment must not be null");
        ENVIRONMENT = environment;
    }

    public static synchronized void resetEnvironment() {
        ENVIRONMENT = new SystemEnvironment();
    }

    public static synchronized Environment getEnvironment() {
        return ENVIRONMENT;
    }

    private static class SystemEnvironment
    implements Environment {
        private SystemEnvironment() {
        }

        @Override
        public Map<String, String> getEnvironmentConfiguration() {
            return System.getenv();
        }
    }

    public static interface Environment {
        public Map<String, String> getEnvironmentConfiguration();
    }
}

