/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal;

import co.decodable.sdk.pipeline.DecodableSourceSplit;
import co.decodable.sdk.pipeline.internal.DecodableSourceSplitImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplit;
import org.apache.flink.core.io.InputStatus;

public class DelegatingSourceReader<T>
implements SourceReader<T, DecodableSourceSplit> {
    private final SourceReader<T, KafkaPartitionSplit> delegate;

    public DelegatingSourceReader(SourceReader<T, KafkaPartitionSplit> delegate) {
        this.delegate = delegate;
    }

    public void close() throws Exception {
        this.delegate.close();
    }

    public void start() {
        this.delegate.start();
    }

    public InputStatus pollNext(ReaderOutput<T> output) throws Exception {
        return this.delegate.pollNext(output);
    }

    public List<DecodableSourceSplit> snapshotState(long checkpointId) {
        return this.delegate.snapshotState(checkpointId).stream().map(DecodableSourceSplitImpl::new).collect(Collectors.toList());
    }

    public CompletableFuture<Void> isAvailable() {
        return this.delegate.isAvailable();
    }

    public void addSplits(List<DecodableSourceSplit> splits) {
        List delegateSplits = splits.stream().map(s -> ((DecodableSourceSplitImpl)s).getDelegate()).collect(Collectors.toList());
        this.delegate.addSplits(delegateSplits);
    }

    public void notifyNoMoreSplits() {
        this.delegate.notifyNoMoreSplits();
    }
}

