/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal.config;

import co.decodable.sdk.pipeline.internal.config.StreamConfig;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StreamConfigMapping {
    private static final Pattern KEY_PATTERN = Pattern.compile("DECODABLE_STREAM_CONFIG_(.*)");
    private static final Set<String> SECRET_PROPERTY_KEYS = Set.of("properties.ssl.keystore.key", "properties.ssl.key.password", "properties.ssl.truststore.password", "properties.sasl.jaas.config", "properties.sasl.mechanism", "properties.ssl.truststore.certificates", "properties.ssl.keystore.certificate.chain");
    private final Map<String, StreamConfig> configsByStreamName = new HashMap<String, StreamConfig>();
    private final Map<String, StreamConfig> configsByStreamId = new HashMap<String, StreamConfig>();

    public StreamConfigMapping(Map<String, String> environment) {
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            Map config;
            Matcher keyMatcher = KEY_PATTERN.matcher(entry.getKey());
            if (!keyMatcher.matches()) continue;
            String streamId = keyMatcher.group(1);
            try {
                config = (Map)mapper.readValue(entry.getValue(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(String.format("Couldn't parse stream configuration env variable %s", entry.getKey()), e);
            }
            String streamName = (String)config.get("name");
            Map properties = (Map)config.get("properties");
            for (String secretKey : SECRET_PROPERTY_KEYS) {
                properties.computeIfPresent(secretKey, (k, v) -> {
                    try {
                        return Files.readString(Paths.get((String)v, new String[0]));
                    }
                    catch (IOException e) {
                        return (String)v;
                    }
                });
            }
            StreamConfig streamConfig = new StreamConfig(streamId, streamName, (Map)config.get("properties"));
            this.configsByStreamId.put(streamId, streamConfig);
            this.configsByStreamName.put(streamName, streamConfig);
        }
    }

    public StreamConfig determineConfig(String streamName, String streamId) {
        StreamConfig streamConfig = null;
        if (streamName != null) {
            if (streamId != null) {
                throw new IllegalStateException("Only one of stream name or stream id may be specified");
            }
            streamConfig = this.configsByStreamName.get(streamName);
            if (streamConfig == null) {
                throw new IllegalStateException(String.format("No topic name could be determined for stream with name '%s'", streamName));
            }
        } else if (streamId != null) {
            streamConfig = this.configsByStreamId.get(streamId);
            if (streamConfig == null) {
                throw new IllegalStateException(String.format("No topic name could be determined for stream with id '%s'", streamId));
            }
        } else {
            throw new IllegalStateException("Either stream name or stream id must be specified");
        }
        return streamConfig;
    }
}

