/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal.metadata;

import co.decodable.sdk.pipeline.metadata.SinkStreams;
import co.decodable.sdk.pipeline.metadata.SourceStreams;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"*"})
public class MetadataProcessor
extends AbstractProcessor {
    private static final Logger LOGGER = Logger.getLogger(MetadataProcessor.class.getName());
    private static final String STREAM_NAMES_FILE = "META-INF/decodable/stream-names.properties";
    private final Set<String> supportedAnnotationClassNames = Set.of(SourceStreams.class, SinkStreams.class).stream().map(Class::getName).collect(Collectors.toSet());
    private final Set<StreamConfig> streamConfigs = new TreeSet<StreamConfig>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set filteredAnnotations = annotations.stream().filter(annotation -> this.supportedAnnotationClassNames.contains(annotation.getQualifiedName().toString())).collect(Collectors.toSet());
        for (TypeElement annotation2 : filteredAnnotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(annotation2);
            for (Element element : annotatedElements) {
                SinkStreams sinkStreams;
                StreamConfig config = new StreamConfig(((TypeElement)element).getQualifiedName().toString());
                this.streamConfigs.add(config);
                SourceStreams sourceStreams = element.getAnnotation(SourceStreams.class);
                if (sourceStreams != null && sourceStreams.value() != null) {
                    config.addSourceStreams(Arrays.asList(sourceStreams.value()));
                }
                if ((sinkStreams = element.getAnnotation(SinkStreams.class)) == null || sinkStreams.value() == null) continue;
                config.addSinkStreams(Arrays.asList(sinkStreams.value()));
            }
        }
        if (roundEnv.processingOver()) {
            if (this.streamConfigs.isEmpty()) {
                LOGGER.log(Level.WARNING, "Neither source nor sink streams were declared. No streams will be available to this pipeline. If this is unintentional, please use the @SourceStreams and @SinkStreams annotations to declare source and/or sink streams.");
            }
            try {
                FileObject streamNamesFile = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", STREAM_NAMES_FILE, new Element[0]);
                try (PrintWriter out = new PrintWriter(streamNamesFile.openWriter());){
                    for (StreamConfig config : this.streamConfigs) {
                        if (!config.sourceStreams.isEmpty()) {
                            out.println(config.className + ".source-streams=" + config.sourceStreams.stream().collect(Collectors.joining(",")));
                        }
                        if (config.sinkStreams.isEmpty()) continue;
                        out.println(config.className + ".sink-streams=" + config.sinkStreams.stream().collect(Collectors.joining(",")));
                    }
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Couldn't generate stream-names.properties file: " + e.getMessage());
            }
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private static class StreamConfig
    implements Comparable<StreamConfig> {
        final String className;
        final Set<String> sourceStreams;
        final Set<String> sinkStreams;

        public StreamConfig(String className) {
            this.className = className;
            this.sourceStreams = new LinkedHashSet<String>();
            this.sinkStreams = new LinkedHashSet<String>();
        }

        public void addSourceStreams(Collection<String> sourceStreams) {
            this.sourceStreams.addAll(sourceStreams);
        }

        public void addSinkStreams(Collection<String> sinkStreams) {
            this.sinkStreams.addAll(sinkStreams);
        }

        public int hashCode() {
            return Objects.hash(this.className);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StreamConfig other = (StreamConfig)obj;
            return Objects.equals(this.className, other.className);
        }

        @Override
        public int compareTo(StreamConfig o) {
            return this.className.compareTo(o.className);
        }
    }
}

