/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.opentracing;

import co.elastic.apm.opentracing.ApmScope;
import co.elastic.apm.opentracing.ApmScopeManager;
import co.elastic.apm.opentracing.ApmSpan;
import co.elastic.apm.opentracing.ApmSpanContext;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

class ApmSpanBuilder
implements Tracer.SpanBuilder {
    @Nullable
    private final String operationName;
    private final Map<String, Object> tags = new HashMap<String, Object>();
    private final ApmScopeManager scopeManager;
    private boolean ignoreActiveSpan = false;
    private long microseconds = -1L;
    @Nullable
    private ApmSpanContext parentContext;

    ApmSpanBuilder(@Nullable String operationName, ApmScopeManager scopeManager) {
        this.operationName = operationName;
        this.scopeManager = scopeManager;
    }

    public ApmSpanBuilder asChildOf(SpanContext parent) {
        if (parent instanceof ApmSpanContext) {
            this.parentContext = (ApmSpanContext)parent;
        }
        return this;
    }

    public ApmSpanBuilder asChildOf(Span parent) {
        if (parent != null) {
            this.asChildOf(parent.context());
        }
        return this;
    }

    public ApmSpanBuilder addReference(String referenceType, SpanContext referencedContext) {
        if ("child_of".equals(referenceType)) {
            this.asChildOf(referencedContext);
        }
        return this;
    }

    public ApmSpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public ApmSpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public ApmSpanBuilder withTag(String key, boolean value) {
        this.tags.put(key, value);
        return this;
    }

    public ApmSpanBuilder withTag(String key, Number value) {
        this.tags.put(key, value);
        return this;
    }

    public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
        this.tags.put(tag.getKey(), value);
        return this;
    }

    public ApmSpanBuilder withStartTimestamp(long microseconds) {
        this.microseconds = microseconds;
        return this;
    }

    @Deprecated
    public ApmScope startActive(boolean finishSpanOnClose) {
        return this.scopeManager.activate(this.startApmSpan(), finishSpanOnClose);
    }

    public ApmSpan start() {
        return this.startApmSpan();
    }

    @Deprecated
    public ApmSpan startManual() {
        return this.start();
    }

    private ApmSpan startApmSpan() {
        ApmScope active;
        if (!this.ignoreActiveSpan && this.parentContext == null && (active = this.scopeManager.active()) != null) {
            this.parentContext = active.span().context();
        }
        Iterable baggage = this.parentContext != null ? this.parentContext.baggageItems() : null;
        Object dispatcher = this.createSpan(this.parentContext != null ? this.parentContext.getTraceContext() : null, baggage);
        ApmSpan apmSpan = new ApmSpan(dispatcher).setOperationName(this.operationName);
        this.addTags(apmSpan);
        return apmSpan;
    }

    @Nullable
    private Object createSpan(Object apmParent, Iterable<Map.Entry<String, String>> baggage) {
        return null;
    }

    private void addTags(ApmSpan apmSpan) {
        for (Map.Entry<String, Object> entry : this.tags.entrySet()) {
            if (entry.getValue() instanceof String) {
                apmSpan.setTag(entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Number) {
                apmSpan.setTag(entry.getKey(), (Number)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof Boolean)) continue;
            apmSpan.setTag(entry.getKey(), (Boolean)entry.getValue());
        }
    }
}

