/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.impl;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Configuration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

/**
 * @since 2.4
 */
class DefaultRootLoggerComponentBuilder extends DefaultComponentAndConfigurationBuilder<RootLoggerComponentBuilder>
        implements RootLoggerComponentBuilder {

    /**
     * Configure the root logger.
     * @param builder
     * @param level
     */
    public DefaultRootLoggerComponentBuilder(final DefaultConfigurationBuilder<? extends Configuration> builder,
            final String level) {
        super(builder, "", "Root");
        if (level != null) {
            addAttribute("level", level);
        }
    }

    /**
     * Configure the root logger.
     * @param builder
     * @param level
     * @param includeLocation
     */
    public DefaultRootLoggerComponentBuilder(final DefaultConfigurationBuilder<? extends Configuration> builder,
            final String level, final boolean includeLocation) {
        super(builder, "", "Root");
        if (level != null) {
            addAttribute("level", level);
        }
        addAttribute("includeLocation", includeLocation);
    }

    /**
     * Configure the root logger.
     * @param builder
     * @param level
     * @param type
     */
    public DefaultRootLoggerComponentBuilder(final DefaultConfigurationBuilder<? extends Configuration> builder,
            final String level, final String type) {
        super(builder, "", type);
        if (level != null) {
            addAttribute("level", level);
        }
    }


    /**
     * Configure the root logger.
     * @param builder
     * @param level
     * @param type
     */
    public DefaultRootLoggerComponentBuilder(final DefaultConfigurationBuilder<? extends Configuration> builder,
            final String level, final String type, final boolean includeLocation) {
        super(builder, "", type);
        if (level != null) {
            addAttribute("level", level);
        }
        addAttribute("includeLocation", includeLocation);
    }

    @Override
    public RootLoggerComponentBuilder add(final AppenderRefComponentBuilder builder) {
        return addComponent(builder);
    }


    @Override
    public RootLoggerComponentBuilder add(final FilterComponentBuilder builder) {
        return addComponent(builder);
    }
}
