/*
 * Copyright 2014 - 2020 Rafael Winterhalter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package co.elastic.apm.agent.shaded.bytebuddy.matcher;

import co.elastic.apm.agent.shaded.bytebuddy.build.HashCodeAndEqualsPlugin;
import co.elastic.apm.agent.shaded.bytebuddy.description.ByteCodeElement;

/**
 * An element matcher that matches a byte code's element's token against a matcher for such a token.
 *
 * @param <T> The type of the matched entity.
 * @param <S> The type of the defined shape of the matched entity.
 */
@HashCodeAndEqualsPlugin.Enhance
public class DefinedShapeMatcher<T extends ByteCodeElement.TypeDependant<S, ?>, S extends ByteCodeElement.TypeDependant<?, ?>>
        extends ElementMatcher.Junction.AbstractBase<T> {

    /**
     * The matcher to apply onto the defined shape of the matched entity.
     */
    private final ElementMatcher<? super S> matcher;

    /**
     * Creates a new matcher for a byte code element's defined shape.
     *
     * @param matcher The matcher to apply onto the defined shape of the matched entity.
     */
    public DefinedShapeMatcher(ElementMatcher<? super S> matcher) {
        this.matcher = matcher;
    }

    /**
     * {@inheritDoc}
     */
    public boolean matches(T target) {
        return matcher.matches(target.asDefined());
    }

    @Override
    public String toString() {
        return "isDefinedAs(" + matcher + ')';
    }
}
