/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.cache;

import co.elastic.apm.agent.shaded.slf4j.Logger;
import co.elastic.apm.agent.shaded.slf4j.LoggerFactory;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import java.lang.ref.SoftReference;
import javax.annotation.Nullable;

public class WeakKeySoftValueLoadingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(WeakKeySoftValueLoadingCache.class);
    private final WeakConcurrentMap<K, CacheValue<K, V>> cache = new WeakConcurrentMap.WithInlinedExpunction<K, CacheValue<K, V>>();
    private final ValueSupplier<K, V> valueSupplier;

    public WeakKeySoftValueLoadingCache(ValueSupplier<K, V> valueSupplier) {
        this.valueSupplier = valueSupplier;
    }

    @Nullable
    public V get(K key) {
        CacheValue<K, V> cacheValue = this.cache.get(key);
        if (cacheValue != null) {
            return cacheValue.get(key);
        }
        CacheValue value = new CacheValue(key, this.valueSupplier);
        this.cache.put(key, value);
        return value.get(key);
    }

    private static class CacheValue<K, V> {
        private final ValueSupplier<K, V> valueSupplier;
        @Nullable
        private SoftReference<V> valueReference;

        private CacheValue(K key, ValueSupplier<K, V> valueSupplier) {
            this.valueSupplier = valueSupplier;
            V value = valueSupplier.get(key);
            if (value != null) {
                this.valueReference = new SoftReference<V>(value);
            }
        }

        @Nullable
        public V get(K key) {
            if (this.valueReference == null) {
                return null;
            }
            V value = this.valueReference.get();
            if (value != null) {
                return value;
            }
            logger.info("The value for the key {} has been collected, reloading it", (Object)key);
            value = this.valueSupplier.get(key);
            this.valueReference = new SoftReference<V>(value);
            return value;
        }
    }

    public static interface ValueSupplier<K, V> {
        @Nullable
        public V get(K var1);
    }
}

