/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import java.util.Arrays;

public class LongList {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CAPACITY = 16;
    private long[] longs;
    private int size;

    public LongList() {
        this(16);
    }

    public LongList(int initialCapacity) {
        this.longs = new long[initialCapacity];
    }

    public static LongList of(long ... values) {
        LongList list = new LongList(values.length);
        for (long value : values) {
            list.add(value);
        }
        return list;
    }

    public void add(long l) {
        this.ensureCapacity(this.size + 1);
        this.longs[this.size++] = l;
    }

    public void addAll(LongList other) {
        this.ensureCapacity(this.size + other.size);
        System.arraycopy(other.longs, 0, this.longs, this.size, other.size);
        this.size += other.size;
    }

    private void ensureCapacity(long minCapacity) {
        if ((long)this.longs.length < minCapacity) {
            this.longs = Arrays.copyOf(this.longs, LongList.newCapacity(minCapacity, this.longs.length));
        }
    }

    static int newCapacity(long minCapacity, long oldCapacity) {
        long growBy50Percent = oldCapacity + (oldCapacity >> 1);
        if (minCapacity <= growBy50Percent) {
            return (int)growBy50Percent;
        }
        if (minCapacity <= 0x7FFFFFF7L) {
            return (int)minCapacity;
        }
        throw new OutOfMemoryError();
    }

    public int getSize() {
        return this.size;
    }

    public long get(int i) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longs[i];
    }

    public boolean contains(long l) {
        for (int i = 0; i < this.size; ++i) {
            if (this.longs[i] != l) continue;
            return true;
        }
        return false;
    }

    public boolean remove(long l) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.longs[i] != l) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public long remove(int i) {
        long previousValue = this.get(i);
        --this.size;
        if (this.size > i) {
            System.arraycopy(this.longs, i + 1, this.longs, i, this.size - i);
        }
        this.longs[this.size] = 0L;
        return previousValue;
    }

    public void clear() {
        Arrays.fill(this.longs, 0L);
        this.size = 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.longs[i]);
        }
        sb.append(']');
        return sb.toString();
    }

    public long[] toArray() {
        return Arrays.copyOfRange(this.longs, 0, this.size);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

