/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.validation;

import co.elastic.apm.agent.shaded.stagemonitor.configuration.ConfigurationOption;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegexValidator
implements ConfigurationOption.Validator<String> {
    private final Pattern pattern;
    private final String errorMessagePattern;

    private RegexValidator(String regex, String errorMessagePattern) {
        this.pattern = Pattern.compile(regex);
        this.errorMessagePattern = errorMessagePattern;
    }

    public static RegexValidator of(String regex) {
        return new RegexValidator(regex, "Value \"{0}\" does not match regex {1}");
    }

    public static RegexValidator of(String regex, String errorMessagePattern) {
        return new RegexValidator(regex, errorMessagePattern);
    }

    @Override
    public void assertValid(@Nullable String value) {
        if (value != null && !this.pattern.matcher(value).matches()) {
            throw new IllegalArgumentException(MessageFormat.format(this.errorMessagePattern, value, this.pattern));
        }
    }
}

