/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo;

import co.elastic.apm.agent.dubbo.AbstractAlibabaDubboInstrumentation;
import co.elastic.apm.agent.dubbo.AlibabaResponseFutureInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import com.alibaba.dubbo.rpc.Result;
import javax.annotation.Nullable;

public abstract class AlibabaResponseCallbackInstrumentation
extends AbstractAlibabaDubboInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseCallback"));
    }

    public static class CaughtInstrumentation
    extends AlibabaResponseCallbackInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("caught").and(ElementMatchers.isOverriddenFrom(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseCallback")));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.This ResponseCallback thiz, @Advice.Local(value="span") AbstractSpan<?> span) {
            span = AlibabaResponseFutureInstrumentation.callbackSpanMap.remove(thiz);
            if (span != null) {
                span.activate();
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.Thrown Throwable thrown, @Nullable @Advice.Local(value="span") AbstractSpan<?> span, @Nullable @Advice.Argument(value=0) Throwable caught) {
            if (span == null) {
                return;
            }
            ((AbstractSpan)((AbstractSpan)((AbstractSpan)span.captureException(thrown)).captureException(caught)).deactivate()).end();
        }
    }

    public static class DoneInstrumentation
    extends AlibabaResponseCallbackInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("done").and(ElementMatchers.isOverriddenFrom(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseCallback")));
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.This ResponseCallback thiz, @Advice.Local(value="span") AbstractSpan<?> span) {
            span = AlibabaResponseFutureInstrumentation.callbackSpanMap.remove(thiz);
            if (span != null) {
                span.activate();
            }
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        private static void onExit(@Advice.Thrown Throwable thrown, @Nullable @Advice.Local(value="span") AbstractSpan<?> span, @Nullable @Advice.Argument(value=0) Object response) {
            if (span == null) {
                return;
            }
            if (response instanceof Result) {
                span.captureException(((Result)response).getException());
            }
            ((AbstractSpan)((AbstractSpan)span.captureException(thrown)).deactivate()).end();
        }
    }
}

