/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.dubbo.AbstractAlibabaDubboInstrumentation;
import co.elastic.apm.agent.dubbo.AlibabaResponseCallbackInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import co.elastic.apm.agent.shaded.weaklockfree.WeakConcurrentMap;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import java.util.Arrays;
import java.util.List;

public class AlibabaResponseFutureInstrumentation
extends AbstractAlibabaDubboInstrumentation {
    public static final WeakConcurrentMap<ResponseCallback, AbstractSpan<?>> callbackSpanMap = new WeakConcurrentMap.WithInlinedExpunction();

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseFuture"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("setCallback");
    }

    @Override
    public Class<?> getAdviceClass() {
        return AlibabaResponseFutureAdvice.class;
    }

    public static class AlibabaResponseFutureAdvice {
        public static final List<Class<? extends ElasticApmInstrumentation>> RESPONSE_CALLBACK_INSTRUMENTATIONS = Arrays.asList(AlibabaResponseCallbackInstrumentation.CaughtInstrumentation.class, AlibabaResponseCallbackInstrumentation.DoneInstrumentation.class);

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onEnter(@Advice.Argument(value=0, readOnly=false) ResponseCallback callback) {
            if (ElasticApmInstrumentation.tracer == null) {
                return;
            }
            AbstractSpan<?> active = ElasticApmInstrumentation.tracer.getActive();
            if (active == null) {
                return;
            }
            callbackSpanMap.put(callback, active);
            ElasticApmAgent.ensureInstrumented(callback.getClass(), RESPONSE_CALLBACK_INSTRUMENTATIONS);
        }
    }
}

