/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo.advice;

import co.elastic.apm.agent.bci.HelperClassManager;
import co.elastic.apm.agent.dubbo.helper.AlibabaDubboAttachmentHelper;
import co.elastic.apm.agent.dubbo.helper.DubboTraceHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.protocol.dubbo.FutureAdapter;
import javax.annotation.Nullable;

public class AlibabaMonitorFilterAdvice {
    @Nullable
    public static ElasticApmTracer tracer;
    public static HelperClassManager<AlibabaDubboAttachmentHelper> helperManager;

    public static void init(ElasticApmTracer tracer) {
        AlibabaMonitorFilterAdvice.tracer = tracer;
        helperManager = HelperClassManager.ForAnyClassLoader.of(tracer, "co.elastic.apm.agent.dubbo.helper.AlibabaDubboAttachmentHelperImpl", new String[0]);
    }

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static void onEnterFilterInvoke(@Advice.Argument(value=1) Invocation invocation, @Advice.Local(value="span") Span span, @Advice.Local(value="apiClazz") Class<?> apiClazz, @Advice.Local(value="transaction") Transaction transaction) {
        RpcContext context = RpcContext.getContext();
        AlibabaDubboAttachmentHelper helper = helperManager.getForClassLoaderOfClass(Invocation.class);
        if (helper == null || tracer == null) {
            return;
        }
        AbstractSpan<?> active = tracer.getActive();
        if (context.isConsumerSide() && active != null) {
            span = DubboTraceHelper.createConsumerSpan(tracer, invocation.getInvoker().getInterface(), invocation.getMethodName(), context.getRemoteAddress());
            if (span != null) {
                span.propagateTraceContext(invocation, helper);
            }
        } else if (active == null && (transaction = tracer.startChildTransaction(invocation, helper, Invocation.class.getClassLoader())) != null) {
            transaction.activate();
            DubboTraceHelper.fillTransaction(transaction, invocation.getInvoker().getInterface(), invocation.getMethodName());
        }
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
    public static void onExitFilterInvoke(@Advice.Argument(value=1) Invocation invocation, @Advice.Return Result result, @Nullable @Advice.Local(value="span") Span span, @Nullable @Advice.Thrown Throwable t, @Nullable @Advice.Local(value="transaction") Transaction transaction) {
        AbstractSpan actualSpan;
        AbstractSpan abstractSpan = actualSpan = span != null ? span : transaction;
        if (actualSpan == null) {
            return;
        }
        ((AbstractSpan)((AbstractSpan)actualSpan.captureException(t)).captureException(result.getException())).deactivate();
        if (!(RpcContext.getContext().getFuture() instanceof FutureAdapter)) {
            actualSpan.end();
        }
    }
}

