/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo.helper;

import co.elastic.apm.agent.dubbo.helper.AsyncCallbackCreator;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import java.util.function.BiConsumer;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;

public class AsyncCallbackCreatorImpl
implements AsyncCallbackCreator {
    private static final BiConsumer<Result, Throwable> INSTANCE = new AsyncCallback();

    @Override
    public BiConsumer<Result, Throwable> create(AbstractSpan<?> span) {
        return INSTANCE;
    }

    public static class AsyncCallback
    implements BiConsumer<Result, Throwable> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Result result, Throwable t) {
            AbstractSpan span = (AbstractSpan)RpcContext.getContext().get("_elastic_apm_span");
            if (span != null) {
                try {
                    RpcContext.getContext().remove("_elastic_apm_span");
                    ((AbstractSpan)span.captureException(t)).captureException(result.getException());
                }
                finally {
                    span.end();
                }
            }
        }
    }
}

