/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grails;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import grails.core.GrailsControllerClass;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.grails.web.mapping.mvc.GrailsControllerUrlMappingInfo;

public class GrailsTransactionNameInstrumentation
extends ElasticApmInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("org.grails.web.mapping.mvc").and(ElementMatchers.hasSuperType(ElementMatchers.named("org.springframework.web.servlet.HandlerAdapter"))).and(ElementMatchers.not(ElementMatchers.isInterface()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("handle").and(ElementMatchers.returns(ElementMatchers.named("org.springframework.web.servlet.ModelAndView"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.servlet.http.HttpServletRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("javax.servlet.http.HttpServletResponse"))).and(ElementMatchers.takesArgument(2, Object.class));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("org.grails.web.mapping.mvc.GrailsControllerUrlMappingInfo");
    }

    @Override
    public Class<?> getAdviceClass() {
        return HandlerAdapterAdvice.class;
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("grails");
    }

    public static class HandlerAdapterAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        static void setTransactionName(@Advice.Argument(value=2) Object handler) {
            String methodName;
            String className;
            if (ElasticApmInstrumentation.tracer == null) {
                return;
            }
            Transaction transaction = ElasticApmInstrumentation.tracer.currentTransaction();
            if (transaction == null) {
                return;
            }
            if (handler instanceof GrailsControllerUrlMappingInfo) {
                GrailsControllerUrlMappingInfo urlMappingInfo = (GrailsControllerUrlMappingInfo)handler;
                GrailsControllerClass grailsControllerClass = urlMappingInfo.getControllerClass();
                className = grailsControllerClass.getShortName();
                String actionName = urlMappingInfo.getActionName();
                methodName = actionName != null ? actionName : "index";
            } else {
                className = handler.getClass().getSimpleName();
                methodName = null;
            }
            HandlerAdapterAdvice.setName(transaction, className, methodName);
        }

        public static void setName(Transaction transaction, String className, @Nullable String methodName) {
            StringBuilder name = transaction.getAndOverrideName(100);
            if (name != null) {
                name.append(className);
                if (methodName != null) {
                    name.append('#').append(methodName);
                }
            }
        }
    }
}

