/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.ElasticApmInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.httpclient.BaseApacheHttpClientInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.shaded.bytebuddy.asm.Advice;
import co.elastic.apm.agent.shaded.bytebuddy.description.NamedElement;
import co.elastic.apm.agent.shaded.bytebuddy.description.method.MethodDescription;
import co.elastic.apm.agent.shaded.bytebuddy.description.type.TypeDescription;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatcher;
import co.elastic.apm.agent.shaded.bytebuddy.matcher.ElementMatchers;
import javax.annotation.Nullable;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.conn.routing.HttpRoute;

public class ApacheHttpClientInstrumentation
extends BaseApacheHttpClientInstrumentation {
    public ApacheHttpClientInstrumentation(ElasticApmTracer tracer) {
        super(tracer);
    }

    @Override
    public Class<?> getAdviceClass() {
        return ApacheHttpClientAdvice.class;
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.http.impl.execchain.ClientExecChain"));
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Exec").or(ElementMatchers.nameContains("Chain"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.impl.execchain.ClientExecChain"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(4)).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.methods.CloseableHttpResponse")))).and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.conn.routing.HttpRoute")))).and(ElementMatchers.takesArgument(1, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.methods.HttpRequestWrapper")))).and(ElementMatchers.takesArgument(2, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.protocol.HttpClientContext")))).and(ElementMatchers.takesArgument(3, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.methods.HttpExecutionAware"))));
    }

    private static class ApacheHttpClientAdvice {
        private ApacheHttpClientAdvice() {
        }

        @Advice.OnMethodEnter(suppress=Throwable.class)
        private static void onBeforeExecute(@Advice.Argument(value=0) HttpRoute route, @Advice.Argument(value=1) HttpRequestWrapper request, @Advice.Local(value="span") Span span) {
            if (ElasticApmInstrumentation.tracer == null || ElasticApmInstrumentation.tracer.getActive() == null) {
                return;
            }
            AbstractSpan<?> parent = ElasticApmInstrumentation.tracer.getActive();
            span = HttpClientHelper.startHttpClientSpan(parent, request.getMethod(), request.getURI(), route.getTargetHost().getHostName());
            TextHeaderSetter<HttpRequest> headerSetter = BaseApacheHttpClientInstrumentation.headerSetterHelperClassManager.getForClassLoaderOfClass(HttpRequest.class);
            TextHeaderGetter<HttpRequest> headerGetter = BaseApacheHttpClientInstrumentation.headerGetterHelperClassManager.getForClassLoaderOfClass(HttpRequest.class);
            if (span != null) {
                span.activate();
                if (headerSetter != null) {
                    span.propagateTraceContext(request, headerSetter);
                }
            } else if (headerGetter != null && !TraceContext.containsTraceContextTextHeaders(request, headerGetter) && headerSetter != null && parent != null) {
                parent.propagateTraceContext(request, headerSetter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class)
        public static void onAfterExecute(@Advice.Return @Nullable CloseableHttpResponse response, @Advice.Local(value="span") @Nullable Span span, @Advice.Thrown @Nullable Throwable t) {
            if (span != null) {
                try {
                    if (response != null && response.getStatusLine() != null) {
                        int statusCode = response.getStatusLine().getStatusCode();
                        span.getContext().getHttp().withStatusCode(statusCode);
                    }
                    span.captureException(t);
                }
                finally {
                    ((Span)span.deactivate()).end();
                }
            }
        }
    }
}

