/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.helper;

import co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelperImpl;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;

class FutureCallbackWrapper<T>
implements FutureCallback<T>,
Recyclable {
    private final ApacheHttpAsyncClientHelperImpl helper;
    @Nullable
    private FutureCallback<T> delegate;
    @Nullable
    private HttpContext context;
    private volatile Span span;

    FutureCallbackWrapper(ApacheHttpAsyncClientHelperImpl helper) {
        this.helper = helper;
    }

    FutureCallbackWrapper<T> with(@Nullable FutureCallback<T> delegate, @Nullable HttpContext context, Span span) {
        this.delegate = delegate;
        this.context = context;
        this.span = span;
        return this;
    }

    public void completed(T result) {
        try {
            this.finishSpan(null);
        }
        finally {
            if (this.delegate != null) {
                this.delegate.completed(result);
            }
            this.helper.recycle(this);
        }
    }

    public void failed(Exception ex) {
        try {
            this.finishSpan(ex);
        }
        finally {
            if (this.delegate != null) {
                this.delegate.failed(ex);
            }
            this.helper.recycle(this);
        }
    }

    public void cancelled() {
        try {
            this.finishSpan(null);
        }
        finally {
            if (this.delegate != null) {
                this.delegate.cancelled();
            }
            this.helper.recycle(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSpan(@Nullable Exception e) {
        Span localSpan = this.span;
        try {
            StatusLine statusLine;
            Object responseObject;
            if (this.context != null && (responseObject = this.context.getAttribute("http.response")) instanceof HttpResponse && (statusLine = ((HttpResponse)responseObject).getStatusLine()) != null) {
                this.span.getContext().getHttp().withStatusCode(statusLine.getStatusCode());
            }
            localSpan.captureException(e);
        }
        finally {
            localSpan.end();
        }
    }

    @Override
    public void resetState() {
        this.delegate = null;
        this.context = null;
        this.span = null;
    }
}

