/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient.helper;

import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelperImpl;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

class HttpAsyncRequestProducerWrapper
implements HttpAsyncRequestProducer,
Recyclable {
    private final ApacheHttpAsyncClientHelperImpl asyncClientHelper;
    private volatile HttpAsyncRequestProducer delegate;
    private Span span;
    private TextHeaderSetter<HttpRequest> headerSetter;

    HttpAsyncRequestProducerWrapper(ApacheHttpAsyncClientHelperImpl helper) {
        this.asyncClientHelper = helper;
    }

    public HttpAsyncRequestProducerWrapper with(HttpAsyncRequestProducer delegate, Span span, TextHeaderSetter<HttpRequest> headerSetter) {
        this.span = span;
        this.headerSetter = headerSetter;
        this.delegate = delegate;
        return this;
    }

    public HttpHost getTarget() {
        return this.delegate.getTarget();
    }

    public HttpRequest generateRequest() throws IOException, HttpException {
        String hostname;
        HttpHost host;
        HttpRequest request = this.delegate.generateRequest();
        if (request != null) {
            RequestLine requestLine = request.getRequestLine();
            if (requestLine != null) {
                String method = requestLine.getMethod();
                ((Span)this.span.withName(method)).appendToName(" ");
                this.span.getContext().getHttp().withMethod(method).withUrl(requestLine.getUri());
            }
            this.span.propagateTraceContext(request, this.headerSetter);
        }
        if ((host = this.getTarget()) != null && (hostname = host.getHostName()) != null) {
            this.span.appendToName(hostname);
            HttpClientHelper.setDestinationServiceDetails(this.span, host.getSchemeName(), hostname, host.getPort());
        }
        return request;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        this.delegate.produceContent(encoder, ioctrl);
    }

    public void requestCompleted(HttpContext context) {
        this.delegate.requestCompleted(context);
    }

    public void failed(Exception ex) {
        this.delegate.failed(ex);
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public void resetRequest() throws IOException {
        this.delegate.resetRequest();
    }

    public void close() throws IOException {
        this.delegate.close();
        this.asyncClientHelper.recycle(this);
    }

    @Override
    public void resetState() {
        this.span = null;
        this.headerSetter = null;
        this.delegate = null;
    }
}

