/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import javax.annotation.Nullable;

public class Destination
implements Recyclable {
    private final StringBuilder address = new StringBuilder();
    private int port;
    private final Service service = new Service();

    public Destination withAddress(@Nullable CharSequence address) {
        if (address != null) {
            return this.withAddress(address, 0, address.length());
        }
        return this;
    }

    public StringBuilder getAddress() {
        return this.address;
    }

    public Destination withPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Destination withAddressPort(@Nullable String addressPort) {
        int port;
        int separator;
        if (addressPort != null && (separator = addressPort.lastIndexOf(58)) > 0 && (port = Destination.parsePort(addressPort, separator + 1, addressPort.length())) > 0) {
            return this.withPort(port).withAddress(addressPort, 0, separator);
        }
        return this;
    }

    private static int parsePort(CharSequence input, int start, int end) {
        int port = 0;
        for (int i = start; i < end; ++i) {
            char c = input.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            port += c - 48;
            if (i >= end - 1) continue;
            port *= 10;
        }
        return port;
    }

    private Destination withAddress(CharSequence address, int start, int end) {
        if (address.length() > 0 && start < end) {
            int startIndex = start;
            int endIndex = end - 1;
            if (address.charAt(startIndex) == '[') {
                ++startIndex;
            }
            if (address.charAt(endIndex) == ']') {
                --endIndex;
            }
            if (startIndex < endIndex) {
                if (this.address.length() > 0) {
                    this.address.delete(0, this.address.length());
                }
                this.address.append(address, startIndex, endIndex + 1);
            }
        }
        return this;
    }

    public Service getService() {
        return this.service;
    }

    public boolean hasContent() {
        return this.address.length() > 0 || this.port > 0 || this.service.hasContent();
    }

    @Override
    public void resetState() {
        this.address.setLength(0);
        this.port = -1;
        this.service.resetState();
    }

    public static class Service
    implements Recyclable {
        private final StringBuilder resource = new StringBuilder();
        private final StringBuilder name = new StringBuilder();
        @Nullable
        private String type;

        public Service withResource(String resource) {
            this.resource.append(resource);
            return this;
        }

        public StringBuilder getResource() {
            return this.resource;
        }

        public Service withName(String name) {
            this.name.append(name);
            return this;
        }

        public StringBuilder getName() {
            return this.name;
        }

        public Service withType(String type) {
            this.type = type;
            return this;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        public boolean hasContent() {
            return this.resource.length() > 0 || this.name.length() > 0 || this.type != null;
        }

        @Override
        public void resetState() {
            this.resource.setLength(0);
            this.name.setLength(0);
            this.type = null;
        }
    }
}

