/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.impl.context.AbstractContext;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.User;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionContext
extends AbstractContext {
    private final Map<String, Object> custom = new ConcurrentHashMap<String, Object>();
    private final Response response = new Response();
    private final Request request = new Request();
    private final User user = new User();

    public void copyFrom(TransactionContext other) {
        super.copyFrom(other);
        this.response.copyFrom(other.response);
        this.request.copyFrom(other.request);
        this.user.copyFrom(other.user);
    }

    public Object getCustom(String key) {
        return this.custom.get(key);
    }

    public Response getResponse() {
        return this.response;
    }

    public void addCustom(String key, String value) {
        this.custom.put(key, value);
    }

    public void addCustom(String key, Number value) {
        this.custom.put(key, value);
    }

    public void addCustom(String key, boolean value) {
        this.custom.put(key, value);
    }

    public boolean hasCustom() {
        return !this.custom.isEmpty();
    }

    public Iterator<? extends Map.Entry<String, ?>> getCustomIterator() {
        return this.custom.entrySet().iterator();
    }

    public Request getRequest() {
        return this.request;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.custom.clear();
        this.response.resetState();
        this.request.resetState();
        this.user.resetState();
    }

    public void onTransactionEnd() {
        this.request.onTransactionEnd();
    }
}

