/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.payload;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.payload.Agent;
import co.elastic.apm.agent.impl.payload.Language;
import co.elastic.apm.agent.impl.payload.Node;
import co.elastic.apm.agent.impl.payload.RuntimeInfo;
import co.elastic.apm.agent.impl.payload.Service;
import co.elastic.apm.agent.util.VersionUtils;

public class ServiceFactory {
    public Service createService(CoreConfiguration coreConfiguration, String ephemeralId) {
        return new Service().withName(coreConfiguration.getServiceName()).withVersion(coreConfiguration.getServiceVersion()).withEnvironment(coreConfiguration.getEnvironment()).withAgent(new Agent("java", this.getAgentVersion(), ephemeralId)).withRuntime(new RuntimeInfo("Java", System.getProperty("java.version"))).withLanguage(new Language("Java", System.getProperty("java.version"))).withNode(new Node(coreConfiguration.getServiceNodeName()));
    }

    private String getAgentVersion() {
        String version = VersionUtils.getVersionFromPomProperties(ServiceFactory.class, "co.elastic.apm", "elastic-apm-agent");
        if (version == null) {
            return "unknown";
        }
        return version;
    }
}

